/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.io.IOException;
import net.nemerosa.ontrack.dsl.Build;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.dsl.http.OTMessageClientException;
import net.nemerosa.ontrack.jenkins.AbstractOntrackNotifier;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackPromotedRunNotifier
extends AbstractOntrackNotifier {
    private final String project;
    private final String branch;
    private final String build;
    private final String promotionLevel;
    private final boolean ignoreFailure;

    @DataBoundConstructor
    public OntrackPromotedRunNotifier(String project, String branch, String build, String promotionLevel, boolean ignoreFailure) {
        this.project = project;
        this.branch = branch;
        this.build = build;
        this.promotionLevel = promotionLevel;
        this.ignoreFailure = ignoreFailure;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getBuild() {
        return this.build;
    }

    public String getPromotionLevel() {
        return this.promotionLevel;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public boolean perform(AbstractBuild<?, ?> theBuild, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String projectName = OntrackPluginSupport.expand(this.project, theBuild, listener);
        String branchName = OntrackPluginSupport.expand(this.branch, theBuild, listener);
        String buildName = OntrackPluginSupport.expand(this.build, theBuild, listener);
        String promotionLevelName = OntrackPluginSupport.expand(this.promotionLevel, theBuild, listener);
        Result result = theBuild.getResult();
        if (result != null && result.isBetterOrEqualTo(Result.SUCCESS)) {
            try {
                Ontrack ontrack = OntrackDSLConnector.createOntrackConnector((TaskListener)listener);
                Build build = ontrack.build(projectName, branchName, buildName);
                listener.getLogger().format("[ontrack] Promoting build %s of branch %s of project %s for %s%n", buildName, branchName, projectName, promotionLevelName);
                build.promote(promotionLevelName);
            }
            catch (OTMessageClientException ex) {
                listener.getLogger().format("[ontrack] ERROR %s%n", ex.getMessage());
                if (!this.ignoreFailure) {
                    theBuild.setResult(Result.FAILURE);
                }
            }
        } else {
            listener.getLogger().format("[ontrack] No promotion to %s since build is broken", promotionLevelName);
        }
        return true;
    }

    @Extension
    public static final class OntrackPromotedRunDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public OntrackPromotedRunDescriptorImpl() {
            super(OntrackPromotedRunNotifier.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Ontrack: Promoted run creation";
        }
    }
}

