/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.triggers.SCMTrigger;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.nemerosa.ontrack.dsl.Build;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.jenkins.OntrackConfiguration;
import net.nemerosa.ontrack.jenkins.Version;
import net.nemerosa.ontrack.jenkins.actions.OntrackLinkAction;
import org.apache.commons.lang.StringUtils;

public final class OntrackPluginSupport {
    public static final String REGEX_ENV_VARIABLE = "\\$\\{([a-zA-Z0-9_]+)}";

    public static String readScript(AbstractBuild build, boolean usingText, String scriptText, String scriptPath) throws IOException {
        if (usingText) {
            return scriptText;
        }
        FilePath workspace = build.getWorkspace();
        if (workspace != null) {
            FilePath path = workspace.child(scriptPath);
            try {
                return path.readToString();
            }
            catch (InterruptedException e) {
                throw new IOException("Cannot read from " + scriptPath, e);
            }
        }
        throw new IOException("Cannot get a workspace to get the script path at " + scriptPath);
    }

    public static String expand(String template, AbstractBuild<?, ?> theBuild, BuildListener listener) {
        if (StringUtils.isBlank((String)template)) {
            return template;
        }
        Pattern pattern = Pattern.compile(REGEX_ENV_VARIABLE);
        Matcher matcher = pattern.matcher(template);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = OntrackPluginSupport.getParameter(name, theBuild, listener);
            if (value == null) {
                throw new IllegalStateException("Cannot find any replacement value for environment variable " + name);
            }
            matcher = matcher.appendReplacement(result, value);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String getParameter(String name, AbstractBuild<?, ?> theBuild, BuildListener listener) {
        String value = (String)theBuild.getBuildVariableResolver().resolve(name);
        if (value != null) {
            return value;
        }
        try {
            return (String)theBuild.getEnvironment((TaskListener)listener).get((Object)name);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot get value for " + name, ex);
        }
    }

    public static Map<String, String> parseProperties(String text, @CheckForNull Run<?, ?> theBuild, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        String[] lines;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (String line : lines = StringUtils.split((String)text, (String)"\n\r")) {
            int pos;
            if (StringUtils.isBlank((String)line) || (line = line.trim()).startsWith("#") || (pos = line.indexOf("=")) <= 0) continue;
            String name = line.substring(0, pos).trim();
            String value = line.substring(pos + 1).trim();
            String expandedValue = theBuild != null && listener != null ? theBuild.getEnvironment(listener).expand(value) : value;
            properties.put(name, expandedValue);
        }
        return properties;
    }

    public static Map<String, Object> getRunInfo(Run theBuild, TaskListener taskListener) throws IOException, InterruptedException {
        long durationMs;
        Jenkins jenkins;
        Version version;
        OntrackConfiguration configuration = OntrackConfiguration.getOntrackConfiguration();
        if (configuration != null && (version = configuration.getVersion()) != null && version.isValid()) {
            boolean versionOk;
            int major = version.getMajor();
            int minor = version.getMinor();
            boolean bl = versionOk = major == 2 && minor >= 35 || major == 3 && minor >= 35 || major > 3;
            if (!versionOk) {
                return Collections.emptyMap();
            }
        }
        if ((jenkins = Jenkins.getInstanceOrNull()) == null) {
            return Collections.emptyMap();
        }
        String url = jenkins.getRootUrl() + theBuild.getUrl();
        String triggerType = null;
        String triggerData = null;
        List causes = theBuild.getCauses();
        if (!causes.isEmpty()) {
            Cause cause = (Cause)causes.get(0);
            if (cause instanceof SCMTrigger.SCMTriggerCause) {
                String svn_revision;
                triggerType = "scm";
                EnvVars environment = theBuild.getEnvironment(taskListener);
                String git_commit = (String)environment.get((Object)"GIT_COMMIT");
                triggerData = StringUtils.isNotBlank((String)git_commit) ? git_commit : (StringUtils.isNotBlank((String)(svn_revision = (String)environment.get((Object)"SVN_REVISION"))) ? svn_revision : "n/a");
            } else if (cause instanceof Cause.UserIdCause) {
                triggerType = "user";
                triggerData = ((Cause.UserIdCause)cause).getUserId();
            }
        }
        long durationSeconds = (durationMs = theBuild.getDuration()) > 0L ? durationMs / 1000L : (System.currentTimeMillis() - theBuild.getStartTimeInMillis()) / 1000L;
        HashMap<String, Object> runInfo = new HashMap<String, Object>();
        runInfo.put("sourceType", "jenkins");
        runInfo.put("sourceUri", url);
        if (triggerType != null && triggerData != null) {
            runInfo.put("triggerType", triggerType);
            runInfo.put("triggerData", triggerData);
        }
        if (durationSeconds > 0L) {
            runInfo.put("runTime", durationSeconds);
        }
        return runInfo;
    }

    private static void addOntrackLink(String name, String suffix, Run run) {
        OntrackConfiguration ontrackConfiguration = OntrackConfiguration.getOntrackConfiguration();
        if (ontrackConfiguration != null) {
            String baseUrl = ontrackConfiguration.getOntrackUrl();
            String url = baseUrl + suffix;
            run.addAction((Action)new OntrackLinkAction(name, url));
        }
    }

    public static void createOntrackLinks(Ontrack ontrack, Run run, Build ontrackBuild) {
        OntrackPluginSupport.addOntrackLink("Ontrack Build", "/#/build/" + ontrackBuild.getId(), run);
        Map<String, Integer> vars = Collections.singletonMap("id", ontrackBuild.getId());
        Object jsonResult = ontrack.graphQLQuery("query BuildInfo($id: Int!) { builds(id: $id) { branch { id project { id } } } }", vars);
        JsonNode json = new ObjectMapper().valueToTree(jsonResult);
        if (json != null) {
            JsonNode branchJson = json.path("data").path("builds").path(0).path("branch");
            int branchId = branchJson.path("id").asInt();
            int projectId = branchJson.path("project").path("id").asInt();
            OntrackPluginSupport.addOntrackLink("Ontrack Branch", "/#/branch/" + branchId, run);
            OntrackPluginSupport.addOntrackLink("Ontrack Project", "/#/project/" + projectId, run);
        }
    }
}

