/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import net.nemerosa.ontrack.jenkins.trigger.JenkinsTriggerJob;
import net.nemerosa.ontrack.jenkins.trigger.TriggerDefinition;
import net.nemerosa.ontrack.jenkins.trigger.TriggerHelper;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackMultiTrigger
extends Trigger<Job> {
    private static final Logger LOGGER = Logger.getLogger(OntrackMultiTrigger.class.getName());
    private static final Level LOG_LEVEL = Level.FINE;
    public static final String SUCCESS = "SUCCESS";
    public static final String FAILURE = "FAILURE";
    public static final String UNSTABLE = "UNSTABLE";
    private final List<TriggerDefinition> triggers;

    @DataBoundConstructor
    public OntrackMultiTrigger(String spec, List<TriggerDefinition> triggers) throws ANTLRException {
        super(spec);
        this.triggers = triggers;
    }

    public List<TriggerDefinition> getTriggers() {
        return this.triggers;
    }

    public void run() {
        if (this.job == null) {
            LOGGER.log(Level.WARNING, "[ontrack][trigger] Cannot run because of job being null.");
            return;
        }
        LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] Check triggers", ((Job)this.job).getFullName()));
        Ontrack ontrack = OntrackDSLConnector.createOntrackConnector(System.out);
        TriggerHelper.evaluate(ontrack, new JenkinsTriggerJob((Job)this.job), this.triggers);
    }

    @Extension
    @Symbol(value={"ontrackMultiTrigger"})
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof Job;
        }

        public String getDisplayName() {
            return "Ontrack: multi trigger";
        }
    }
}

