/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.RelativePath;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.http.HttpHeaders;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.oic.Messages;
import org.jenkinsci.plugins.oic.OicSecurityRealm;
import org.jenkinsci.plugins.oic.OicServerConfiguration;
import org.jenkinsci.plugins.oic.ProxyAwareResourceRetriever;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class OicServerWellKnownConfiguration
extends OicServerConfiguration {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(OicServerWellKnownConfiguration.class.getName());
    private final String wellKnownOpenIDConfigurationUrl;
    private String scopesOverride;
    private transient LocalDateTime wellKnownExpires = null;
    private volatile transient OIDCProviderMetadata oidcProviderMetadata;

    @DataBoundConstructor
    public OicServerWellKnownConfiguration(String wellKnownOpenIDConfigurationUrl) {
        this.wellKnownOpenIDConfigurationUrl = Objects.requireNonNull(wellKnownOpenIDConfigurationUrl);
    }

    @DataBoundSetter
    public void setScopesOverride(String scopesOverride) {
        this.scopesOverride = Util.fixEmptyAndTrim((String)scopesOverride);
    }

    public String getScopesOverride() {
        return this.scopesOverride;
    }

    public String getWellKnownOpenIDConfigurationUrl() {
        return this.wellKnownOpenIDConfigurationUrl;
    }

    @Restricted(value={DoNotUse.class})
    void invalidateProviderMetadata() {
        this.oidcProviderMetadata = null;
    }

    @Override
    public OIDCProviderMetadata toProviderMetadata() {
        LocalDateTime now = LocalDateTime.now();
        if (this.wellKnownExpires != null && this.wellKnownExpires.isBefore(now)) {
            return this.oidcProviderMetadata;
        }
        ProxyAwareResourceRetriever rr = ((OicSecurityRealm)Jenkins.get().getSecurityRealm()).getResourceRetriever();
        try {
            List idTokenJWSAlgs;
            List tokenEndpointAuthMethods;
            OIDCProviderMetadata _oidcProviderMetadata = OIDCProviderMetadata.parse((String)rr.retrieveResource(new URL(this.wellKnownOpenIDConfigurationUrl)).getContent());
            String _scopesOverride = this.getScopesOverride();
            if (_scopesOverride != null) {
                String[] splitScopes = _scopesOverride.split("\\s+");
                _oidcProviderMetadata.setScopes(new Scope(splitScopes));
            }
            if ((tokenEndpointAuthMethods = _oidcProviderMetadata.getTokenEndpointAuthMethods()) != null) {
                ArrayList<ClientAuthenticationMethod> filteredEndpointAuthMethods = new ArrayList<ClientAuthenticationMethod>(tokenEndpointAuthMethods);
                filteredEndpointAuthMethods.removeIf(cam -> cam != ClientAuthenticationMethod.CLIENT_SECRET_BASIC && cam != ClientAuthenticationMethod.CLIENT_SECRET_POST);
                if (filteredEndpointAuthMethods.isEmpty()) {
                    LOGGER.log(Level.WARNING, "OIDC well-known configuration reports only unsupported token authentication methods (authentication may not work): " + tokenEndpointAuthMethods.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]")));
                    _oidcProviderMetadata.setTokenEndpointAuthMethods(null);
                } else {
                    _oidcProviderMetadata.setTokenEndpointAuthMethods(filteredEndpointAuthMethods);
                }
            }
            if ((idTokenJWSAlgs = _oidcProviderMetadata.getIDTokenJWSAlgs()) != null && idTokenJWSAlgs.contains(Algorithm.NONE)) {
                ArrayList _idTokenJWSAlgs = new ArrayList(idTokenJWSAlgs);
                _idTokenJWSAlgs.remove(Algorithm.NONE);
                _oidcProviderMetadata.setIDTokenJWSAlgs(_idTokenJWSAlgs);
            }
            this.oidcProviderMetadata = _oidcProviderMetadata;
            this.setWellKnownExpires(null);
            return this.oidcProviderMetadata;
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Invalid WellKnown OpenID Configuration URL", e);
        }
        catch (ParseException e) {
            LOGGER.log(Level.SEVERE, "Could not parse wellknown OpenID Configuration", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while loading wellknown OpenID Configuration", e);
        }
        if (this.oidcProviderMetadata != null) {
            return this.oidcProviderMetadata;
        }
        throw new IllegalStateException("Well known configuration could not be loaded, login can not proceed.");
    }

    private void setWellKnownExpires(@CheckForNull HttpHeaders headers) {
        ZonedDateTime zdt;
        Optional expires;
        Optional<Object> optional = expires = headers == null ? Optional.empty() : headers.firstValue("Expires");
        if (expires.isPresent() && !"0".equals(expires.get()) && (zdt = ZonedDateTime.parse((CharSequence)expires.get(), DateTimeFormatter.RFC_1123_DATE_TIME)) != null) {
            this.wellKnownExpires = zdt.toLocalDateTime();
            return;
        }
        this.wellKnownExpires = LocalDateTime.now().plusSeconds(3600L);
    }

    @Extension
    @Symbol(value={"wellKnown"})
    public static class DescriptorImpl
    extends Descriptor<OicServerConfiguration> {
        public String getDisplayName() {
            return Messages.OicServerWellKnownConfiguration_DisplayName();
        }

        @POST
        public FormValidation doCheckWellKnownOpenIDConfigurationUrl(@QueryParameter String wellKnownOpenIDConfigurationUrl, @RelativePath(value="..") @QueryParameter boolean disableSslVerification) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (wellKnownOpenIDConfigurationUrl == null || wellKnownOpenIDConfigurationUrl.isBlank()) {
                return FormValidation.error((String)Messages.OicSecurityRealm_NotAValidURL());
            }
            try {
                ProxyAwareResourceRetriever prr = ProxyAwareResourceRetriever.createProxyAwareResourceRetriver(disableSslVerification);
                OIDCProviderMetadata providerMetadata = OIDCProviderMetadata.parse((String)prr.retrieveResource(new URL(wellKnownOpenIDConfigurationUrl)).getContent());
                if (providerMetadata.getAuthorizationEndpointURI() == null || providerMetadata.getTokenEndpointURI() == null) {
                    return FormValidation.warning((String)Messages.OicSecurityRealm_URLNotAOpenIdEnpoint());
                }
                return FormValidation.ok();
            }
            catch (SSLException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_SSLErrorRetreivingWellKnownConfig());
            }
            catch (IOException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_ErrorRetreivingWellKnownConfig());
            }
            catch (ParseException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_URLNotAOpenIdEnpoint());
            }
        }

        @POST
        public FormValidation doCheckOverrideScopes(@QueryParameter String overrideScopes) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)overrideScopes) == null) {
                return FormValidation.ok();
            }
            if (!overrideScopes.toLowerCase().contains("openid")) {
                return FormValidation.warning((String)Messages.OicSecurityRealm_RUSureOpenIdNotInScope());
            }
            return FormValidation.ok();
        }
    }
}

