/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic;

import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;

public class OicUserProperty
extends UserProperty {
    private static final Logger LOGGER = Logger.getLogger(OicUserProperty.class.getName());
    private final List<String> authorities = new ArrayList<String>();
    private final String userName;

    public OicUserProperty(String userName, GrantedAuthority[] authorities) {
        this.userName = userName;
        for (GrantedAuthority authority : authorities) {
            this.authorities.add(authority.getAuthority());
        }
    }

    public List<String> getAuthorities() {
        return Collections.unmodifiableList(this.authorities);
    }

    public GrantedAuthority[] getAuthoritiesAsGrantedAuthorities() {
        GrantedAuthority[] authorities = new GrantedAuthority[this.authorities.size()];
        for (int i = 0; i < authorities.length; ++i) {
            authorities[i] = new GrantedAuthorityImpl(this.authorities.get(i));
        }
        return authorities;
    }

    public String getAllGrantedAuthorities() {
        StringBuilder result = new StringBuilder();
        result.append("Number of GrantedAuthorities in OicUserProperty for ").append(this.userName).append(": ").append(this.authorities.size());
        for (String authority : this.authorities) {
            result.append("<br>\nAuthority: ").append(authority);
        }
        return result.toString();
    }

    public String getUserName() {
        return this.userName;
    }

    public UserPropertyDescriptor getDescriptor() {
        return new Descriptor();
    }

    public static class Descriptor
    extends UserPropertyDescriptor {
        public UserProperty newInstance(User user) {
            LOGGER.fine("OicUserPropertyDescriptor.newInstance called, user:" + user);
            return new OicUserProperty(user.getId(), new GrantedAuthority[0]);
        }

        public String getDisplayName() {
            return "OpenID Connect user property";
        }
    }
}

