/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.AuthorizationCodeResponseUrl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Failure;
import hudson.remoting.Base64;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

abstract class OicSession {
    private final AuthorizationCodeFlow flow;
    private final String state = Base64.encode((byte[])UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8)).substring(0, 20);
    private final String from;
    private final String redirectUrl;
    private String idToken;
    private static final String SESSION_NAME = OicSession.class.getName();

    OicSession(AuthorizationCodeFlow flow, String from, String redirectUrl) {
        this.flow = flow;
        this.from = from;
        this.redirectUrl = redirectUrl;
    }

    @SuppressFBWarnings(value={"J2EE_STORE_OF_NON_SERIALIZABLE_OBJECT_INTO_SESSION"})
    public HttpResponse doCommenceLogin() throws IOException {
        Stapler.getCurrentRequest().getSession().setAttribute(SESSION_NAME, (Object)this);
        AuthorizationCodeRequestUrl authorizationCodeRequestUrl = this.flow.newAuthorizationUrl().setState(this.state).setRedirectUri(this.redirectUrl);
        return new HttpRedirect(authorizationCodeRequestUrl.toString());
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        AuthorizationCodeResponseUrl responseUrl;
        StringBuffer buf = request.getRequestURL();
        if (request.getQueryString() != null) {
            buf.append('?').append(request.getQueryString());
        }
        if (!this.state.equals((responseUrl = new AuthorizationCodeResponseUrl(buf.toString())).getState())) {
            return new Failure("State is invalid");
        }
        String code = responseUrl.getCode();
        if (responseUrl.getError() != null) {
            return new Failure("Error from provider: " + responseUrl.getError() + ". Details: " + responseUrl.getErrorDescription());
        }
        if (code == null) {
            return new Failure("Missing authorization code");
        }
        return this.onSuccess(code);
    }

    protected String getFrom() {
        return this.from;
    }

    public String getState() {
        return this.state;
    }

    protected abstract HttpResponse onSuccess(String var1) throws IOException;

    public static OicSession getCurrent() {
        return (OicSession)Stapler.getCurrentRequest().getSession().getAttribute(SESSION_NAME);
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public String getIdToken() {
        return this.idToken;
    }
}

