/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.ConnectionFactory;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.SecurityRealm;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.oic.JenkinsAwareConnectionFactory;
import org.jenkinsci.plugins.oic.OicSession;
import org.jenkinsci.plugins.oic.OicUserDetails;
import org.jenkinsci.plugins.oic.OicUserProperty;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.dao.DataAccessException;

public class OicSecurityRealm
extends SecurityRealm {
    private static final Logger LOGGER = Logger.getLogger(OicSecurityRealm.class.getName());
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static final String ID_TOKEN_REQUEST_ATTRIBUTE = "oic-id-token";
    private static final String STATE_REQUEST_ATTRIBUTE = "oic-state";
    private final String clientId;
    private final Secret clientSecret;
    private final String tokenServerUrl;
    private final String authorizationServerUrl;
    private final String userInfoServerUrl;
    private final String userNameField;
    private final String tokenFieldToCheckKey;
    private final String tokenFieldToCheckValue;
    private final String fullNameFieldName;
    private final String emailFieldName;
    private final String groupsFieldName;
    private final String scopes;
    private final boolean disableSslVerification;
    private final boolean logoutFromOpenidProvider;
    private final String endSessionUrl;
    private final String postLogoutRedirectUrl;
    private final boolean escapeHatchEnabled;
    private final String escapeHatchUsername;
    private final Secret escapeHatchSecret;
    private final String escapeHatchGroup;
    private transient HttpTransport httpTransport;
    private transient Random random;

    @DataBoundConstructor
    public OicSecurityRealm(String clientId, String clientSecret, String tokenServerUrl, String authorizationServerUrl, String userInfoServerUrl, String userNameField, String tokenFieldToCheckKey, String tokenFieldToCheckValue, String fullNameFieldName, String emailFieldName, String scopes, String groupsFieldName, boolean disableSslVerification, boolean logoutFromOpenidProvider, String endSessionUrl, String postLogoutRedirectUrl, boolean escapeHatchEnabled, String escapeHatchUsername, String escapeHatchSecret, String escapeHatchGroup) throws IOException {
        this.clientId = clientId;
        this.clientSecret = Secret.fromString((String)clientSecret);
        this.tokenServerUrl = tokenServerUrl;
        this.authorizationServerUrl = authorizationServerUrl;
        this.userInfoServerUrl = userInfoServerUrl;
        this.userNameField = Util.fixEmpty((String)userNameField) == null ? "sub" : userNameField;
        this.tokenFieldToCheckKey = Util.fixEmpty((String)tokenFieldToCheckKey);
        this.tokenFieldToCheckValue = Util.fixEmpty((String)tokenFieldToCheckValue);
        this.fullNameFieldName = Util.fixEmpty((String)fullNameFieldName);
        this.emailFieldName = Util.fixEmpty((String)emailFieldName);
        this.scopes = Util.fixEmpty((String)scopes) == null ? "openid email" : scopes;
        this.groupsFieldName = Util.fixEmpty((String)groupsFieldName);
        this.disableSslVerification = disableSslVerification;
        this.logoutFromOpenidProvider = logoutFromOpenidProvider;
        this.endSessionUrl = endSessionUrl;
        this.postLogoutRedirectUrl = postLogoutRedirectUrl;
        this.escapeHatchEnabled = escapeHatchEnabled;
        this.escapeHatchUsername = Util.fixEmpty((String)escapeHatchUsername);
        this.escapeHatchSecret = Secret.fromString((String)escapeHatchSecret);
        this.escapeHatchGroup = Util.fixEmpty((String)escapeHatchGroup);
        this.httpTransport = this.constructHttpTransport(this.isDisableSslVerification());
        this.random = new Random();
    }

    private Object readResolve() {
        if (this.httpTransport == null) {
            this.httpTransport = this.constructHttpTransport(this.isDisableSslVerification());
        }
        if (this.random == null) {
            this.random = new Random();
        }
        return this;
    }

    private HttpTransport constructHttpTransport(boolean disableSslVerification) {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        builder.setConnectionFactory((ConnectionFactory)new JenkinsAwareConnectionFactory());
        if (disableSslVerification) {
            try {
                builder.doNotValidateCertificate();
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public String getClientId() {
        return this.clientId;
    }

    public Secret getClientSecret() {
        return this.clientSecret;
    }

    public String getTokenServerUrl() {
        return this.tokenServerUrl;
    }

    public String getAuthorizationServerUrl() {
        return this.authorizationServerUrl;
    }

    public String getUserInfoServerUrl() {
        return this.userInfoServerUrl;
    }

    public String getUserNameField() {
        return this.userNameField;
    }

    public String getTokenFieldToCheckKey() {
        return this.tokenFieldToCheckKey;
    }

    public String getTokenFieldToCheckValue() {
        return this.tokenFieldToCheckValue;
    }

    public String getFullNameFieldName() {
        return this.fullNameFieldName;
    }

    public String getEmailFieldName() {
        return this.emailFieldName;
    }

    public String getGroupsFieldName() {
        return this.groupsFieldName;
    }

    public String getScopes() {
        return this.scopes;
    }

    public boolean isDisableSslVerification() {
        return this.disableSslVerification;
    }

    public boolean isLogoutFromOpenidProvider() {
        return this.logoutFromOpenidProvider;
    }

    public String getEndSessionUrl() {
        return this.endSessionUrl;
    }

    public String getPostLogoutRedirectUrl() {
        return this.postLogoutRedirectUrl;
    }

    public boolean isEscapeHatchEnabled() {
        return this.escapeHatchEnabled;
    }

    public String getEscapeHatchUsername() {
        return this.escapeHatchUsername;
    }

    public Secret getEscapeHatchSecret() {
        return this.escapeHatchSecret;
    }

    public String getEscapeHatchGroup() {
        return this.escapeHatchGroup;
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    public String getAuthenticationGatewayUrl() {
        return "securityRealm/escapeHatch";
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof AnonymousAuthenticationToken) {
                    return authentication;
                }
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        }, new UserDetailsService(){

            public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
                LOGGER.fine("loadUserByUsername in createSecurityComponents called, username: " + username);
                User u = User.get((String)username);
                LOGGER.fine("loadUserByUsername in createSecurityComponents called, user: " + u);
                List props = u.getAllProperties();
                LOGGER.fine("loadUserByUsername in createSecurityComponents called, number of props: " + props.size());
                GrantedAuthority[] auths = new GrantedAuthority[]{};
                for (UserProperty prop : props) {
                    LOGGER.fine("loadUserByUsername in createSecurityComponents called, prop of type: " + prop.getClass().toString());
                    if (!(prop instanceof OicUserProperty)) continue;
                    OicUserProperty oicProp = (OicUserProperty)prop;
                    LOGGER.fine("loadUserByUsername in createSecurityComponents called, oic prop found with username: " + oicProp.getUserName());
                    auths = oicProp.getAuthoritiesAsGrantedAuthorities();
                    LOGGER.fine("loadUserByUsername in createSecurityComponents called, oic prop with auths size: " + auths.length);
                }
                return new OicUserDetails(username, auths);
            }
        });
    }

    public HttpResponse doCommenceLogin(@QueryParameter String from, @Header(value="Referer") String referer) throws IOException {
        final String redirectOnFinish = this.determineRedirectTarget(from, referer);
        final AuthorizationCodeFlow flow = new AuthorizationCodeFlow.Builder(BearerToken.queryParameterAccessMethod(), this.httpTransport, JSON_FACTORY, new GenericUrl(this.tokenServerUrl), new ClientParametersAuthentication(this.clientId, this.clientSecret.getPlainText()), this.clientId, this.authorizationServerUrl).setScopes(Arrays.asList(this.scopes)).build();
        return new OicSession(flow, from, this.buildOAuthRedirectUrl()){

            @Override
            public HttpResponse onSuccess(String authorizationCode) {
                try {
                    Object username;
                    IdTokenResponse response = IdTokenResponse.execute(flow.newTokenRequest(authorizationCode).setRedirectUri(OicSecurityRealm.this.buildOAuthRedirectUrl()));
                    this.setIdToken(response.getIdToken());
                    IdToken idToken = IdToken.parse(JSON_FACTORY, response.getIdToken());
                    GenericJson userInfo = null;
                    if (Strings.isNullOrEmpty((String)OicSecurityRealm.this.userInfoServerUrl)) {
                        username = idToken.getPayload().get(OicSecurityRealm.this.userNameField);
                        if (username == null) {
                            return HttpResponses.error((int)500, (String)("no field '" + OicSecurityRealm.this.userNameField + "' was supplied in the token payload to be used as the username"));
                        }
                    } else {
                        userInfo = OicSecurityRealm.this.getUserInfo(flow, response.getAccessToken());
                        username = userInfo.get((Object)OicSecurityRealm.this.userNameField);
                        if (username == null) {
                            return HttpResponses.error((int)500, (String)("no field '" + OicSecurityRealm.this.userNameField + "' was supplied by the UserInfo payload to be used as the username"));
                        }
                    }
                    if (OicSecurityRealm.this.failedCheckOfTokenField(idToken)) {
                        return HttpResponses.errorWithoutStack((int)401, (String)"Unauthorized");
                    }
                    flow.createAndStoreCredential(response, null);
                    OicSecurityRealm.this.loginAndSetUserData(username.toString(), idToken, userInfo);
                    return new HttpRedirect(redirectOnFinish);
                }
                catch (IOException e) {
                    return HttpResponses.error((int)500, (Throwable)e);
                }
            }
        }.doCommenceLogin();
    }

    public HttpResponse doEscapeHatch(@QueryParameter(value="j_username") String username, @QueryParameter(value="j_password") String password) {
        this.randomWait();
        if (!this.isEscapeHatchEnabled()) {
            return HttpResponses.redirectViaContextPath((String)"loginError");
        }
        if (this.escapeHatchUsername == null || this.escapeHatchSecret == null) {
            return HttpResponses.redirectViaContextPath((String)"loginError");
        }
        if (this.escapeHatchUsername.equalsIgnoreCase(username) && this.escapeHatchSecret.getPlainText().equals(password)) {
            ArrayList<Object> authorities = new ArrayList<Object>();
            authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
            if (StringUtils.isNotBlank((String)this.escapeHatchGroup)) {
                authorities.add(new GrantedAuthorityImpl(this.escapeHatchGroup));
            }
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"escape-hatch-admin", (Object)"", authorities.toArray(new GrantedAuthority[authorities.size()]));
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
            return HttpRedirect.CONTEXT_ROOT;
        }
        return HttpResponses.redirectViaContextPath((String)"loginError");
    }

    private void randomWait() {
        try {
            Thread.sleep(1000 + this.random.nextInt(1000));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private GenericJson getUserInfo(AuthorizationCodeFlow flow, final String accessToken) throws IOException {
        HttpRequestFactory requestFactory = flow.getTransport().createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                request.getHeaders().setAuthorization("Bearer " + accessToken);
            }
        });
        HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(this.userInfoServerUrl));
        request.setParser((ObjectParser)new JsonObjectParser(flow.getJsonFactory()));
        request.setThrowExceptionOnExecuteError(false);
        com.google.api.client.http.HttpResponse response = request.execute();
        if (response.isSuccessStatusCode()) {
            return (GenericJson)response.parseAs(GenericJson.class);
        }
        throw new HttpResponseException(response);
    }

    private boolean failedCheckOfTokenField(IdToken idToken) {
        if (this.tokenFieldToCheckKey == null || this.tokenFieldToCheckValue == null) {
            return false;
        }
        Object value = idToken.getPayload().get(this.tokenFieldToCheckKey);
        if (value == null) {
            return true;
        }
        return this.tokenFieldToCheckValue.equals(String.valueOf(value));
    }

    private UsernamePasswordAuthenticationToken loginAndSetUserData(String userName, IdToken idToken, GenericJson userInfo) throws IOException {
        String fullName;
        String email;
        GrantedAuthority[] grantedAuthorities = this.determineAuthorities(idToken, userInfo);
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder grantedAuthoritiesAsString = new StringBuilder("(");
            for (GrantedAuthority grantedAuthority : grantedAuthorities) {
                grantedAuthoritiesAsString.append(" ").append(grantedAuthority.getAuthority());
            }
            grantedAuthoritiesAsString.append(" )");
            LOGGER.finest("GrantedAuthorities:" + grantedAuthoritiesAsString);
        }
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)userName, (Object)"", grantedAuthorities);
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        User user = User.get((String)token.getName());
        user.addProperty((UserProperty)new OicUserProperty(userName, grantedAuthorities));
        String string = email = userInfo == null ? this.getField(idToken, this.emailFieldName) : (String)userInfo.get((Object)this.emailFieldName);
        if (email != null) {
            user.addProperty((UserProperty)new Mailer.UserProperty(email));
        }
        String string2 = fullName = userInfo == null ? this.getField(idToken, this.fullNameFieldName) : (String)userInfo.get((Object)this.fullNameFieldName);
        if (fullName != null) {
            user.setFullName(fullName);
        }
        return token;
    }

    private GrantedAuthority[] determineAuthorities(IdToken idToken, GenericJson userInfo) {
        ArrayList<Object> grantedAuthorities = new ArrayList<Object>();
        grantedAuthorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        if (StringUtils.isNotBlank((String)this.groupsFieldName)) {
            if (Strings.isNullOrEmpty((String)this.userInfoServerUrl)) {
                if (idToken.getPayload().containsKey(this.groupsFieldName)) {
                    LOGGER.fine("idToken contains group field name: " + this.groupsFieldName + " with value class:" + idToken.getPayload().get(this.groupsFieldName).getClass());
                    List groupNames = (List)idToken.getPayload().get(this.groupsFieldName);
                    LOGGER.fine("Number of groups in groupNames: " + groupNames.size());
                    for (String groupName : groupNames) {
                        LOGGER.fine("Adding group from idToken: " + groupName);
                        grantedAuthorities.add(new GrantedAuthorityImpl(groupName));
                    }
                } else {
                    LOGGER.warning("idToken did not contain group field name: " + this.groupsFieldName);
                }
            } else if (userInfo.containsKey((Object)this.groupsFieldName)) {
                LOGGER.fine("UserInfo contains group field name: " + this.groupsFieldName + " with value class:" + userInfo.get((Object)this.groupsFieldName).getClass());
                List groupNames = (List)userInfo.get((Object)this.groupsFieldName);
                LOGGER.fine("Number of groups in groupNames: " + groupNames.size());
                for (String groupName : groupNames) {
                    LOGGER.fine("Adding group from UserInfo: " + groupName);
                    grantedAuthorities.add(new GrantedAuthorityImpl(groupName));
                }
            } else {
                LOGGER.warning("UserInfo did not contain group field name: " + this.groupsFieldName);
            }
        } else {
            LOGGER.fine("Not adding groups because groupsFieldName is not set. groupsFieldName=" + this.groupsFieldName);
        }
        return grantedAuthorities.toArray(new GrantedAuthority[grantedAuthorities.size()]);
    }

    private String getField(IdToken idToken, String fullNameFieldName) {
        Object value = idToken.getPayload().get(fullNameFieldName);
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    public void doLogout(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        OicSession oicSession = OicSession.getCurrent();
        if (oicSession != null) {
            req.setAttribute(ID_TOKEN_REQUEST_ATTRIBUTE, (Object)oicSession.getIdToken());
            req.setAttribute(STATE_REQUEST_ATTRIBUTE, (Object)oicSession.getState());
        }
        super.doLogout(req, rsp);
    }

    public String getPostLogOutUrl(StaplerRequest req, Authentication auth) {
        if (this.logoutFromOpenidProvider) {
            StringBuilder openidLogoutEndpoint = new StringBuilder(this.endSessionUrl);
            openidLogoutEndpoint.append("/?id_token_hint=").append(req.getAttribute(ID_TOKEN_REQUEST_ATTRIBUTE));
            openidLogoutEndpoint.append("&state=").append(req.getAttribute(STATE_REQUEST_ATTRIBUTE));
            if (this.postLogoutRedirectUrl != null) {
                openidLogoutEndpoint.append("&post_logout_redirect_uri=").append(this.postLogoutRedirectUrl);
            }
            return openidLogoutEndpoint.toString();
        }
        return super.getPostLogOutUrl(req, auth);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private String determineRedirectTarget(@QueryParameter String from, @Header(value="Referer") String referer) {
        String target = from != null ? from : (referer != null ? referer : Jenkins.getInstance().getRootUrl());
        return target;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private String buildOAuthRedirectUrl() throws NullPointerException {
        String rootUrl = Jenkins.getInstance().getRootUrl();
        if (rootUrl == null) {
            throw new NullPointerException("Jenkins root url should not be null");
        }
        return rootUrl + "securityRealm/finishLogin";
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        return OicSession.getCurrent().doFinishLogin(request);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return "Login with Openid Connect";
        }

        public FormValidation doCheckClientId(@QueryParameter String clientId) {
            if (clientId == null || clientId.trim().length() == 0) {
                return FormValidation.error((String)"Client id is required.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckClientSecret(@QueryParameter String clientSecret) {
            if (clientSecret == null || clientSecret.trim().length() == 0) {
                return FormValidation.error((String)"Client secret is required.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTokenServerUrl(@QueryParameter String tokenServerUrl) {
            if (tokenServerUrl == null) {
                return FormValidation.error((String)"Token Server Url Key is required.");
            }
            try {
                new URL(tokenServerUrl);
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)"Not a valid url.");
            }
        }

        public FormValidation doCheckAuthorizationServerUrl(@QueryParameter String authorizationServerUrl) {
            if (authorizationServerUrl == null) {
                return FormValidation.error((String)"Token Server Url Key is required.");
            }
            try {
                new URL(authorizationServerUrl);
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)"Not a valid url.");
            }
        }

        public FormValidation doCheckUserNameField(@QueryParameter String userNameField) {
            if (userNameField == null || userNameField.trim().length() == 0) {
                return FormValidation.ok((String)"Using 'sub'.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckScopes(@QueryParameter String scopes) {
            if (scopes == null || scopes.trim().length() == 0) {
                return FormValidation.ok((String)"Using 'openid email'.");
            }
            if (!scopes.toLowerCase().contains("openid")) {
                return FormValidation.warning((String)"Are you sure you don't want to include 'openid' as an scope?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEndSessionUrl(@QueryParameter String endSessionUrl) {
            if (endSessionUrl == null || endSessionUrl.equals("")) {
                return FormValidation.error((String)"End Session URL Key is required.");
            }
            try {
                new URL(endSessionUrl);
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)"Not a valid url.");
            }
        }

        public FormValidation doCheckPostLogoutRedirectUrl(@QueryParameter String postLogoutRedirectUrl) {
            if (postLogoutRedirectUrl != null && !postLogoutRedirectUrl.equals("")) {
                try {
                    new URL(postLogoutRedirectUrl);
                    return FormValidation.ok();
                }
                catch (MalformedURLException e) {
                    return FormValidation.error((Throwable)e, (String)"Not a valid url.");
                }
            }
            return FormValidation.ok();
        }
    }
}

