/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nunit;

import hudson.plugins.nunit.InvalidXmlStreamReader;
import hudson.plugins.nunit.TestReportTransformer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NUnitReportTransformer
implements TestReportTransformer,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(NUnitReportTransformer.class.getName());
    private static final String ILLEGAL_FILE_CHARS_REGEX = "[\\*/:<>\\?\\|\\\\\";]+";
    private static final long serialVersionUID = 1L;
    public static final String JUNIT_FILE_POSTFIX = ".xml";
    public static final String JUNIT_FILE_PREFIX = "TEST-";
    private static final int MAX_PATH = 255;
    private static final String TEMP_JUNIT_FILE_STR = "temp-junit.xml";
    public static final String NUNIT_TO_JUNIT_XSLFILE_STR = "nunit-to-junit.xsl";
    private static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private transient boolean xslIsInitialized;
    private transient Transformer nunitTransformer;
    private transient Transformer writerTransformer;
    private transient DocumentBuilder xmlDocumentBuilder;
    private transient int transformCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(InputStream nunitFileStream, File junitOutputPath) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        this.initialize();
        File junitTargetFile = new File(junitOutputPath, TEMP_JUNIT_FILE_STR);
        try (FileOutputStream fileOutputStream = new FileOutputStream(junitTargetFile);){
            BufferedReader reader = new BufferedReader(new InvalidXmlStreamReader(nunitFileStream, '?'));
            this.nunitTransformer.transform(new StreamSource(reader), new StreamResult(fileOutputStream));
        }
        this.splitJUnitFile(junitTargetFile, junitOutputPath);
        junitTargetFile.delete();
    }

    private void initialize() throws TransformerFactoryConfigurationError, TransformerConfigurationException, ParserConfigurationException {
        if (!this.xslIsInitialized) {
            TransformerFactory transformerFactory = this.createTransformer();
            this.nunitTransformer = transformerFactory.newTransformer(new StreamSource(this.getClass().getResourceAsStream(NUNIT_TO_JUNIT_XSLFILE_STR)));
            this.writerTransformer = transformerFactory.newTransformer();
            DocumentBuilderFactory factory = this.createDocumentBuilderFactory();
            this.xmlDocumentBuilder = factory.newDocumentBuilder();
            this.xslIsInitialized = true;
        }
    }

    private TransformerFactory createTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", null);
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        return transformerFactory;
    }

    private DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", null);
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        dFactory.setExpandEntityReferences(false);
        features.put(DISALLOW_DOCTYPE_DECL, true);
        features.put(EXTERNAL_GENERAL_ENTITIES, false);
        features.put(EXTERNAL_PARAMETER_ENTITIES, false);
        features.put(LOAD_EXTERNAL_DTD, false);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", true);
        for (String feature : features.keySet()) {
            try {
                dFactory.setFeature(feature, (Boolean)features.get(feature));
            }
            catch (ParserConfigurationException e) {
                LOGGER.log(Level.INFO, "Could not enable/disable feature: " + feature);
            }
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        attributes.put("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        for (String attribute : attributes.keySet()) {
            try {
                dFactory.setAttribute(attribute, attributes.get(attribute));
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.INFO, "Could not set attribute: " + attribute);
            }
        }
        dFactory.setXIncludeAware(false);
        dFactory.setExpandEntityReferences(false);
        return dFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitJUnitFile(File junitFile, File junitOutputPath) throws SAXException, IOException, TransformerException {
        block7: {
            ++this.transformCount;
            try {
                Document document = this.xmlDocumentBuilder.parse(junitFile);
                NodeList elementsByTagName = ((Element)document.getElementsByTagName("testsuites").item(0)).getElementsByTagName("testsuite");
                for (int i = 0; i < elementsByTagName.getLength(); ++i) {
                    Element element = (Element)elementsByTagName.item(i);
                    DOMSource source = new DOMSource(element);
                    String fileNamePostfix = "_" + this.transformCount + "_" + i + JUNIT_FILE_POSTFIX;
                    String filename = JUNIT_FILE_PREFIX + element.getAttribute("name").replaceAll(ILLEGAL_FILE_CHARS_REGEX, "_") + fileNamePostfix;
                    File junitOutputFile = new File(junitOutputPath, filename);
                    if (junitOutputFile.toString().length() >= 255) {
                        int maxMiddleLength = 255 - JUNIT_FILE_PREFIX.length() - fileNamePostfix.length() - junitOutputPath.toString().length();
                        filename = JUNIT_FILE_PREFIX + StringUtils.left((String)element.getAttribute("name").replaceAll(ILLEGAL_FILE_CHARS_REGEX, "_"), (int)maxMiddleLength) + fileNamePostfix;
                        junitOutputFile = new File(junitOutputPath, filename);
                    }
                    try (FileOutputStream fileOutputStream = new FileOutputStream(junitOutputFile);){
                        StreamResult result = new StreamResult(fileOutputStream);
                        this.writerTransformer.transform(source, result);
                        continue;
                    }
                }
            }
            catch (SAXParseException e) {
                if (e.getMessage().startsWith("Premature end of file")) break block7;
                throw e;
            }
        }
    }
}

