/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nunit;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.nunit.NUnitArchiver;
import hudson.plugins.nunit.NUnitReportTransformer;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import javax.annotation.Nonnull;
import jenkins.security.MasterToSlaveCallable;
import jenkins.security.Roles;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.BooleanUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class NUnitPublisher
extends Recorder
implements Serializable,
SimpleBuildStep {
    private static final long serialVersionUID = 1L;
    private static final transient String PLUGIN_NUNIT = "/plugin/nunit/";
    private String testResultsPattern;
    private boolean debug = false;
    private boolean keepJUnitReports = false;
    private boolean skipJUnitArchiver = false;
    private Double healthScaleFactor;
    private boolean failIfNoResults;
    private boolean failedTestsFailBuild;

    @Deprecated
    public NUnitPublisher(String testResultsPattern, boolean debug, boolean keepJUnitReports, boolean skipJUnitArchiver) {
        this(testResultsPattern, debug, keepJUnitReports, skipJUnitArchiver, Boolean.TRUE, Boolean.FALSE);
    }

    @Deprecated
    public NUnitPublisher(String testResultsPattern, boolean debug, boolean keepJUnitReports, boolean skipJUnitArchiver, Boolean failIfNoResults, Boolean failedTestsFailBuild) {
        this.testResultsPattern = testResultsPattern;
        this.debug = debug;
        if (this.debug) {
            this.keepJUnitReports = keepJUnitReports;
            this.skipJUnitArchiver = skipJUnitArchiver;
        }
        this.failIfNoResults = BooleanUtils.toBooleanDefaultIfNull((Boolean)failIfNoResults, (boolean)Boolean.TRUE);
        this.failedTestsFailBuild = BooleanUtils.toBooleanDefaultIfNull((Boolean)failedTestsFailBuild, (boolean)Boolean.FALSE);
    }

    @DataBoundConstructor
    public NUnitPublisher(String testResultsPattern) {
        this.testResultsPattern = testResultsPattern;
        this.failIfNoResults = true;
    }

    public Object readResolve() {
        return new NUnitPublisher(this.testResultsPattern, this.debug, this.keepJUnitReports, this.skipJUnitArchiver, BooleanUtils.toBooleanDefaultIfNull((Boolean)this.failIfNoResults, (boolean)Boolean.TRUE), BooleanUtils.toBooleanDefaultIfNull((Boolean)this.failedTestsFailBuild, (boolean)Boolean.FALSE));
    }

    public String getTestResultsPattern() {
        return this.testResultsPattern;
    }

    @DataBoundSetter
    public void setTestResultsPattern(String testResultsPattern) {
        this.testResultsPattern = testResultsPattern;
    }

    public boolean getDebug() {
        return this.debug;
    }

    @DataBoundSetter
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getKeepJUnitReports() {
        return this.keepJUnitReports;
    }

    @DataBoundSetter
    public void setKeepJUnitReports(boolean keepJUnitReports) {
        if (this.debug) {
            this.keepJUnitReports = keepJUnitReports;
        }
    }

    public double getHealthScaleFactor() {
        return this.healthScaleFactor == null ? 1.0 : this.healthScaleFactor;
    }

    @DataBoundSetter
    public void setHealthScaleFactor(double healthScaleFactor) {
        this.healthScaleFactor = Math.max(0.0, healthScaleFactor);
    }

    public boolean getSkipJUnitArchiver() {
        return this.skipJUnitArchiver;
    }

    @DataBoundSetter
    public void setSkipJUnitArchiver(boolean skipJUnitArchiver) {
        if (this.debug) {
            this.skipJUnitArchiver = skipJUnitArchiver;
        }
    }

    public boolean getFailIfNoResults() {
        return this.failIfNoResults;
    }

    @DataBoundSetter
    public void setFailIfNoResults(boolean failIfNoResults) {
        this.failIfNoResults = failIfNoResults;
    }

    public boolean getFailedTestsFailBuild() {
        return this.failedTestsFailBuild;
    }

    @DataBoundSetter
    public void setFailedTestsFailBuild(boolean failedTestsFailBuild) {
        this.failedTestsFailBuild = failedTestsFailBuild;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        TestResultProjectAction action = (TestResultProjectAction)project.getAction(TestResultProjectAction.class);
        if (action == null) {
            return new TestResultProjectAction(project);
        }
        return action;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recordTestResult(String junitFilePattern, Run<?, ?> build, TaskListener listener, FilePath filePath) throws InterruptedException, IOException {
        Run<?, ?> run = build;
        synchronized (run) {
            TestResultAction action;
            TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
            long buildTime = build.getTimestamp().getTimeInMillis();
            TestResult existingTestResults = null;
            if (existingAction != null) {
                existingTestResults = existingAction.getResult();
            }
            TestResult result = this.getTestResult(junitFilePattern, build, existingTestResults, buildTime, filePath);
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            action.setHealthScaleFactor(this.getHealthScaleFactor());
            if (this.failIfNoResults && result.getPassCount() == 0 && result.getFailCount() == 0 && result.getSkipCount() == 0) {
                listener.getLogger().println("None of the test reports contained any result");
                build.setResult(Result.FAILURE);
                return true;
            }
            if (existingAction == null) {
                build.addAction((Action)action);
            }
            if (action.getResult().getFailCount() > 0) {
                if (this.failedTestsFailBuild) {
                    build.setResult(Result.FAILURE);
                } else {
                    build.setResult(Result.UNSTABLE);
                }
            }
            return true;
        }
    }

    private TestResult getTestResult(final String junitFilePattern, Run<?, ?> build, final TestResult existingTestResults, final long buildTime, final FilePath filePath) throws IOException, InterruptedException {
        TestResult result = (TestResult)filePath.act((Callable)new MasterToSlaveCallable<TestResult, IOException>(){
            private static final long serialVersionUID = -8917897415838795523L;

            public TestResult call() throws IOException {
                FileSet fs = Util.createFileSet((File)new File(filePath.getRemote()), (String)junitFilePattern);
                DirectoryScanner ds = fs.getDirectoryScanner();
                String[] files = ds.getIncludedFiles();
                if (files.length == 0) {
                    if (NUnitPublisher.this.failIfNoResults) {
                        throw new AbortException("No test report files were found or the NUnit input XML file contained no tests.");
                    }
                    return new TestResult();
                }
                if (existingTestResults == null) {
                    return new TestResult(buildTime, ds, true);
                }
                existingTestResults.parse(buildTime, ds);
                return existingTestResults;
            }

            public void checkRoles(RoleChecker roleChecker) throws SecurityException {
                roleChecker.check((RoleSensitive)this, Roles.MASTER);
            }
        });
        return result;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath ws, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        if (this.debug) {
            listener.getLogger().println("NUnit publisher running in debug mode.");
        }
        try {
            EnvVars env = run.getEnvironment(listener);
            String resolvedTestResultsPattern = env.expand(this.testResultsPattern);
            listener.getLogger().println("Recording NUnit tests results");
            String junitTempReportsDirectoryName = "tempJunitReports" + UUID.randomUUID().toString();
            NUnitArchiver transformer = new NUnitArchiver(ws.getRemote(), junitTempReportsDirectoryName, listener, resolvedTestResultsPattern, new NUnitReportTransformer(), this.failIfNoResults);
            boolean result = (Boolean)ws.act((Callable)transformer);
            if (result) {
                if (this.skipJUnitArchiver) {
                    listener.getLogger().println("Skipping feeding JUnit reports to JUnitArchiver");
                } else {
                    this.recordTestResult(junitTempReportsDirectoryName + "/TEST-*.xml", run, listener, ws);
                }
                if (this.keepJUnitReports) {
                    listener.getLogger().println("Skipping deletion of temporary JUnit reports.");
                } else {
                    ws.child(junitTempReportsDirectoryName).deleteRecursive();
                }
            } else if (this.getFailIfNoResults()) {
                run.setResult(Result.FAILURE);
            }
        }
        catch (AbortException e) {
            throw e;
        }
        catch (IOException e) {
            listener.getLogger().println("Error in NUnit processing: " + e.getMessage());
            throw new AbortException("Could not read the XSL XML file. Please report this issue to the plugin author");
        }
    }

    @Extension
    @Symbol(value={"nunit"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(NUnitPublisher.class);
        }

        public String getDisplayName() {
            return "Publish NUnit test result report";
        }

        public String getHelpFile() {
            return "/plugin/nunit/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

