/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nunit;

import hudson.plugins.nunit.InvalidXmlInputStream;
import hudson.plugins.nunit.TestReportTransformer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NUnitReportTransformer
implements TestReportTransformer,
Serializable {
    private static final String ILLEGAL_FILE_CHARS_REGEX = "[\\*/:<>\\?\\|\\\\\";]+";
    private static final long serialVersionUID = 1L;
    public static final String JUNIT_FILE_POSTFIX = ".xml";
    public static final String JUNIT_FILE_PREFIX = "TEST-";
    private static final int MAX_PATH = 255;
    private static final String TEMP_JUNIT_FILE_STR = "temp-junit.xml";
    public static final String NUNIT_TO_JUNIT_XSLFILE_STR = "nunit-to-junit.xsl";
    private transient boolean xslIsInitialized;
    private transient Transformer nunitTransformer;
    private transient Transformer writerTransformer;
    private transient DocumentBuilder xmlDocumentBuilder;
    private transient int transformCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(InputStream nunitFileStream, File junitOutputPath) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        this.initialize();
        File junitTargetFile = new File(junitOutputPath, TEMP_JUNIT_FILE_STR);
        try (FileOutputStream fileOutputStream = new FileOutputStream(junitTargetFile);){
            InvalidXmlInputStream is = new InvalidXmlInputStream((InputStream)new BOMInputStream(nunitFileStream), '?');
            this.nunitTransformer.transform(new StreamSource((InputStream)((Object)is)), new StreamResult(fileOutputStream));
        }
        this.splitJUnitFile(junitTargetFile, junitOutputPath);
        junitTargetFile.delete();
    }

    private void initialize() throws TransformerFactoryConfigurationError, TransformerConfigurationException, ParserConfigurationException {
        if (!this.xslIsInitialized) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.nunitTransformer = transformerFactory.newTransformer(new StreamSource(this.getClass().getResourceAsStream(NUNIT_TO_JUNIT_XSLFILE_STR)));
            this.writerTransformer = transformerFactory.newTransformer();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.xmlDocumentBuilder = factory.newDocumentBuilder();
            this.xslIsInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitJUnitFile(File junitFile, File junitOutputPath) throws SAXException, IOException, TransformerException {
        block7: {
            ++this.transformCount;
            try {
                Document document = this.xmlDocumentBuilder.parse(junitFile);
                NodeList elementsByTagName = ((Element)document.getElementsByTagName("testsuites").item(0)).getElementsByTagName("testsuite");
                for (int i = 0; i < elementsByTagName.getLength(); ++i) {
                    Element element = (Element)elementsByTagName.item(i);
                    DOMSource source = new DOMSource(element);
                    String fileNamePostfix = "_" + this.transformCount + "_" + i + JUNIT_FILE_POSTFIX;
                    String filename = JUNIT_FILE_PREFIX + element.getAttribute("name").replaceAll(ILLEGAL_FILE_CHARS_REGEX, "_") + fileNamePostfix;
                    File junitOutputFile = new File(junitOutputPath, filename);
                    if (junitOutputFile.toString().length() >= 255) {
                        int maxMiddleLength = 255 - JUNIT_FILE_PREFIX.length() - fileNamePostfix.length() - junitOutputPath.toString().length();
                        filename = JUNIT_FILE_PREFIX + StringUtils.left((String)element.getAttribute("name").replaceAll(ILLEGAL_FILE_CHARS_REGEX, "_"), (int)maxMiddleLength) + fileNamePostfix;
                        junitOutputFile = new File(junitOutputPath, filename);
                    }
                    try (FileOutputStream fileOutputStream = new FileOutputStream(junitOutputFile);){
                        StreamResult result = new StreamResult(fileOutputStream);
                        this.writerTransformer.transform(source, result);
                        continue;
                    }
                }
            }
            catch (SAXParseException e) {
                if (e.getMessage().startsWith("Premature end of file")) break block7;
                throw e;
            }
        }
    }
}

