/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nomad;

import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.nomad.NomadConstraintTemplate;
import org.jenkinsci.plugins.nomad.NomadDevicePluginTemplate;
import org.jenkinsci.plugins.nomad.NomadPortTemplate;
import org.kohsuke.stapler.DataBoundConstructor;

public class NomadWorkerTemplate
implements Describable<NomadWorkerTemplate> {
    private static final String SLAVE_PREFIX = "jenkins";
    private static final Logger LOGGER = Logger.getLogger(NomadWorkerTemplate.class.getName());
    private final int idleTerminationInMinutes;
    private final Boolean reusable;
    private final int numExecutors;
    private final String prefix;
    private final int cpu;
    private final int memory;
    private final int disk;
    private final int priority;
    private final String labels;
    private final List<? extends NomadConstraintTemplate> constraints;
    private final String region;
    private final String remoteFs;
    private final Boolean useRawExec;
    private final String image;
    private final Boolean privileged;
    private final String network;
    private final String username;
    private final String password;
    private final String prefixCmd;
    private final Boolean forcePull;
    private final String hostVolumes;
    private final String switchUser;
    private final Node.Mode mode;
    private final List<? extends NomadPortTemplate> ports;
    private final String extraHosts;
    private final String dnsServers;
    private final String securityOpt;
    private final String capAdd;
    private final String capDrop;
    private final String datacenters;
    private final String vaultPolicies;
    private final Set<LabelAtom> labelSet;
    private final List<? extends NomadDevicePluginTemplate> devicePlugins;
    private String driver;

    @DataBoundConstructor
    public NomadWorkerTemplate(String prefix, String cpu, String memory, String disk, String labels, List<? extends NomadConstraintTemplate> constraints, String remoteFs, Boolean useRawExec, String idleTerminationInMinutes, Boolean reusable, String numExecutors, Node.Mode mode, String region, String priority, String image, String datacenters, String username, String password, Boolean privileged, String network, String prefixCmd, Boolean forcePull, String hostVolumes, String switchUser, List<? extends NomadPortTemplate> ports, String extraHosts, String dnsServers, String securityOpt, String capAdd, String capDrop, String vaultPolicies, List<? extends NomadDevicePluginTemplate> devicePlugins) {
        this.prefix = StringUtils.isNotEmpty((String)prefix) ? prefix : SLAVE_PREFIX;
        this.cpu = Integer.parseInt(cpu);
        this.memory = Integer.parseInt(memory);
        this.disk = Integer.parseInt(disk);
        this.priority = Integer.parseInt(priority);
        this.idleTerminationInMinutes = Integer.parseInt(idleTerminationInMinutes);
        this.reusable = reusable;
        this.numExecutors = Integer.parseInt(numExecutors);
        this.mode = mode;
        this.remoteFs = remoteFs;
        this.useRawExec = useRawExec;
        this.labels = Util.fixNull((String)labels);
        this.constraints = constraints == null ? Collections.emptyList() : constraints;
        this.labelSet = Label.parse((String)labels);
        this.region = region;
        this.image = image;
        this.datacenters = datacenters;
        this.vaultPolicies = Util.fixNull((String)vaultPolicies);
        this.username = username;
        this.password = password;
        this.privileged = privileged;
        this.network = network;
        this.prefixCmd = prefixCmd;
        this.switchUser = switchUser;
        this.forcePull = forcePull;
        this.hostVolumes = hostVolumes;
        this.ports = ports == null ? Collections.emptyList() : ports;
        this.extraHosts = extraHosts;
        this.dnsServers = dnsServers;
        this.securityOpt = securityOpt;
        this.capAdd = capAdd;
        this.capDrop = capDrop;
        this.devicePlugins = devicePlugins == null ? Collections.emptyList() : devicePlugins;
        this.readResolve();
    }

    protected Object readResolve() {
        String string = this.driver = !this.image.equals("") ? "docker" : "java";
        if (this.useRawExec.booleanValue()) {
            this.driver = "raw_exec";
        }
        return this;
    }

    public Descriptor<NomadWorkerTemplate> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    public String createWorkerName() {
        return this.getPrefix() + "-" + Long.toHexString(System.nanoTime());
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public int getNumExecutors() {
        return this.numExecutors;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public String getPrefix() {
        if (StringUtils.isNotEmpty((String)this.prefix)) {
            return this.prefix;
        }
        return SLAVE_PREFIX;
    }

    public int getCpu() {
        return this.cpu;
    }

    public int getMemory() {
        return this.memory;
    }

    public String getLabels() {
        return this.labels;
    }

    public List<NomadConstraintTemplate> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public int getIdleTerminationInMinutes() {
        return this.idleTerminationInMinutes;
    }

    public Boolean getReusable() {
        return this.reusable;
    }

    public String getRegion() {
        return this.region;
    }

    public String getDatacenters() {
        return this.datacenters;
    }

    public String getVaultPolicies() {
        return this.vaultPolicies;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getDisk() {
        return this.disk;
    }

    public String getRemoteFs() {
        return this.remoteFs;
    }

    public Boolean useRawExec() {
        return this.useRawExec;
    }

    public String getImage() {
        return this.image;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrefixCmd() {
        return this.prefixCmd;
    }

    public String getSwitchUser() {
        return this.switchUser;
    }

    public String getDriver() {
        return this.driver;
    }

    public Boolean isDockerDriver() {
        return this.getDriver().equals("docker");
    }

    public Boolean isJavaDriver() {
        return this.getDriver().equals("java");
    }

    public Boolean isRawExecDriver() {
        return this.getDriver().equals("raw_exec");
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public String getNetwork() {
        return this.network;
    }

    public Boolean getForcePull() {
        return this.forcePull;
    }

    public String getHostVolumes() {
        return this.hostVolumes;
    }

    public List<? extends NomadPortTemplate> getPorts() {
        return Collections.unmodifiableList(this.ports);
    }

    public String getSecurityOpt() {
        return this.securityOpt;
    }

    public String getCapAdd() {
        return this.capAdd;
    }

    public String getCapDrop() {
        return this.capDrop;
    }

    public String getExtraHosts() {
        return this.extraHosts;
    }

    public String getDnsServers() {
        return this.dnsServers;
    }

    public List<NomadDevicePluginTemplate> getDevicePlugins() {
        return Collections.unmodifiableList(this.devicePlugins);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<NomadWorkerTemplate> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "";
        }
    }
}

