/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter.parameterizedtrigger;

import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactoryDescriptor;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.jvnet.jenkins.plugins.nodelabelparameter.Messages;
import org.jvnet.jenkins.plugins.nodelabelparameter.parameterizedtrigger.NodeLabelBuildParameter;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllNodesBuildParameterFactory
extends AbstractBuildParameterFactory {
    @DataBoundConstructor
    public AllNodesBuildParameterFactory() {
    }

    public List<AbstractBuildParameters> getParameters(AbstractBuild<?, ?> build, TaskListener listener) {
        Computer[] nodes = Jenkins.getInstance().getComputers();
        PrintStream logger = listener.getLogger();
        ArrayList params = Lists.newArrayList();
        for (Computer c : nodes) {
            Node n = c.getNode();
            if (n == null || !c.isOnline() || c.getNumExecutors() <= 0) continue;
            params.add(new NodeLabelBuildParameter("label", n.getSelfLabel().getName()));
            logger.println("trigger build on " + n.getDisplayName() + " (" + n.getSelfLabel().getName() + ")");
        }
        return params;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractBuildParameterFactoryDescriptor {
        public String getDisplayName() {
            return Messages.AllNodesBuildParameterFactory_displayName();
        }
    }
}

