/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.tasks.BuildWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelBadgeAction;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelParameterValue;
import org.jvnet.jenkins.plugins.nodelabelparameter.Messages;
import org.jvnet.jenkins.plugins.nodelabelparameter.NodeParameterDefinition;
import org.jvnet.jenkins.plugins.nodelabelparameter.NodeUtil;
import org.jvnet.jenkins.plugins.nodelabelparameter.wrapper.TriggerNextBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeParameterValue
extends LabelParameterValue {
    private static final Logger LOGGER = Logger.getLogger(NodeParameterValue.class.getName());
    private static final long serialVersionUID = 1L;
    private List<String> nextLabels;

    @DataBoundConstructor
    public NodeParameterValue(String name, List<String> labels, boolean ignoreOfflineNodes) {
        super(name);
        if (labels != null && !labels.isEmpty()) {
            this.nextLabels = new ArrayList<String>();
            if (ignoreOfflineNodes) {
                for (String nodeName : labels) {
                    if (NodeUtil.isNodeOnline(nodeName = nodeName.trim())) {
                        if (this.getLabel() == null) {
                            this.setLabel(nodeName);
                            continue;
                        }
                        this.nextLabels.add(nodeName);
                        continue;
                    }
                    LOGGER.fine("Skipping execution on offline node [" + nodeName + "]");
                }
            } else {
                this.setLabel(labels.get(0).trim());
                if (labels.size() > 1) {
                    List<String> subList = labels.subList(1, labels.size());
                    for (String l : subList) {
                        this.nextLabels.add(l.trim());
                    }
                }
            }
        }
        if (this.getLabel() == null || this.getLabel().length() == 0) {
            if (ignoreOfflineNodes) {
                this.setLabel("Job triggered without a valid online node, given where: " + StringUtils.join(labels, (char)','));
            } else {
                this.setLabel("Job triggered, but no node given");
            }
        }
    }

    public NodeParameterValue(String name, String description, String label) {
        super(name, description, label);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[NodeParameterValue: ");
        s.append(this.name).append("=").append(this.getLabel());
        if (this.nextLabels != null && !this.nextLabels.isEmpty()) {
            s.append(", nextNodes=").append(StringUtils.join(this.nextLabels, (char)','));
        }
        s.append("]");
        return s.toString();
    }

    public List<String> getNextLabels() {
        return Collections.unmodifiableList(this.nextLabels == null ? new ArrayList() : this.nextLabels);
    }

    @Override
    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        build.addAction((Action)new LabelBadgeAction(this.getLabel(), Messages.LabelBadgeAction_node_tooltip(this.getLabel())));
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)build.getProject().getProperty(ParametersDefinitionProperty.class);
        if (property != null) {
            List parameterDefinitions = property.getParameterDefinitions();
            for (ParameterDefinition paramDef : parameterDefinitions) {
                if (!(paramDef instanceof NodeParameterDefinition)) continue;
                NodeParameterDefinition nodeParameterDefinition = (NodeParameterDefinition)paramDef;
                if (nodeParameterDefinition.getAllowMultiNodeSelection()) {
                    return new TriggerNextBuildWrapper(nodeParameterDefinition);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeParameterValue that = (NodeParameterValue)((Object)o);
        return !(this.nextLabels != null ? !((Object)this.nextLabels).equals(that.nextLabels) : that.nextLabels != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.nextLabels != null ? ((Object)this.nextLabels).hashCode() : 0);
        return result;
    }
}

