/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter.parameterizedtrigger;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactoryDescriptor;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jvnet.jenkins.plugins.nodelabelparameter.Messages;
import org.jvnet.jenkins.plugins.nodelabelparameter.parameterizedtrigger.NodeLabelBuildParameter;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllNodesForLabelBuildParameterFactory
extends AbstractBuildParameterFactory {
    public final String name;
    public final String nodeLabel;
    private static final Function<Node, String> SELF_LABEL_FUNCTION = new Function<Node, String>(){

        public String apply(Node node) {
            return node.getSelfLabel().getName();
        }
    };

    @DataBoundConstructor
    public AllNodesForLabelBuildParameterFactory(String name, String nodeLabel) {
        this.name = name;
        this.nodeLabel = nodeLabel;
    }

    public List<AbstractBuildParameters> getParameters(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        String labelExpanded = this.nodeLabel;
        try {
            labelExpanded = TokenMacro.expandAll(build, (TaskListener)listener, (String)labelExpanded);
        }
        catch (MacroEvaluationException e) {
            labelExpanded = this.nodeLabel;
            e.printStackTrace(listener.getLogger());
        }
        listener.getLogger().println("Getting all nodes with label: " + labelExpanded);
        Set nodes = Hudson.getInstance().getLabel(labelExpanded).getNodes();
        List selfLabels = Lists.transform(new ArrayList(nodes), SELF_LABEL_FUNCTION);
        listener.getLogger().println("Found nodes: " + String.valueOf(selfLabels));
        ArrayList params = Lists.newArrayList();
        if (nodes == null || nodes.isEmpty()) {
            params.add(new NodeLabelBuildParameter(this.name, labelExpanded));
        } else {
            for (Node node : nodes) {
                params.add(new NodeLabelBuildParameter(this.name, node.getSelfLabel().getName()));
            }
        }
        return params;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractBuildParameterFactoryDescriptor {
        public String getDisplayName() {
            return Messages.AllNodesForLabelBuildParameterFactory_displayName();
        }
    }
}

