/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.ParameterValue;
import hudson.model.labels.LabelAtom;
import hudson.model.queue.SubTask;
import hudson.tasks.BuildWrapper;
import hudson.util.VariableResolver;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelBadgeAction;
import org.jvnet.jenkins.plugins.nodelabelparameter.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelParameterValue
extends ParameterValue {
    @Exported(visibility=3)
    private String label;

    public LabelParameterValue(String name) {
        super(name);
    }

    @DataBoundConstructor
    public LabelParameterValue(String name, String label) {
        super(name);
        if (label != null) {
            this.label = label.trim();
        }
    }

    public LabelParameterValue(String name, String description, String label) {
        super(name, description);
        if (label != null) {
            this.label = label.trim();
        }
    }

    public Label getAssignedLabel(SubTask task) {
        return new LabelAtom(this.label);
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String name) {
                return LabelParameterValue.this.name.equals(name) ? LabelParameterValue.this.label : null;
            }
        };
    }

    public String toString() {
        return "[LabelParameterValue: " + this.name + "=" + this.label + "]";
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label != null) {
            this.label = label.trim();
        }
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        return new AddBadgeBuildWrapper();
    }

    private class AddBadgeBuildWrapper
    extends BuildWrapper {
        private AddBadgeBuildWrapper() {
        }

        public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
            Computer c = Computer.currentComputer();
            if (c != null) {
                String cName = StringUtils.isBlank((String)c.getName()) ? "master" : c.getName();
                build.addAction((Action)new LabelBadgeAction(LabelParameterValue.this.getLabel(), Messages.LabelBadgeAction_label_tooltip_node(LabelParameterValue.this.getLabel(), cName)));
            } else {
                build.addAction((Action)new LabelBadgeAction(LabelParameterValue.this.getLabel(), Messages.LabelBadgeAction_label_tooltip(LabelParameterValue.this.getLabel())));
            }
            return new BuildWrapper.Environment(){};
        }
    }
}

