/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter.wrapper;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelParameterValue;
import org.jvnet.jenkins.plugins.nodelabelparameter.NextLabelCause;
import org.jvnet.jenkins.plugins.nodelabelparameter.NodeParameterValue;

public class TriggerNextBuildWrapper
extends BuildWrapper {
    private static final Logger LOGGER = Logger.getLogger(TriggerNextBuildWrapper.class.getName());
    private String triggerIfResult;

    public TriggerNextBuildWrapper(String triggerIfResult) {
        this.triggerIfResult = triggerIfResult;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ParametersAction origParamsAction = (ParametersAction)build.getAction(ParametersAction.class);
        if (origParamsAction == null) {
            return new BuildWrapper.Environment(){};
        }
        return new TriggerNextBuildEnvironment();
    }

    private class TriggerNextBuildEnvironment
    extends BuildWrapper.Environment {
        private TriggerNextBuildEnvironment() {
            super((BuildWrapper)TriggerNextBuildWrapper.this);
        }

        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            ParametersAction origParamsAction = (ParametersAction)build.getAction(ParametersAction.class);
            List origParams = origParamsAction.getParameters();
            ArrayList<ParameterValue> newPrams = new ArrayList<ParameterValue>();
            boolean triggerNewBuild = false;
            NextLabelCause nextLabelCause = null;
            for (ParameterValue parameterValue : origParams) {
                if (parameterValue instanceof LabelParameterValue) {
                    NodeParameterValue origNodePram;
                    List<String> nextNodes;
                    if (!(parameterValue instanceof LabelParameterValue) || (nextNodes = (origNodePram = (NodeParameterValue)parameterValue).getNextLabels()) == null || nextNodes.isEmpty() || !this.shouldScheduleNextJob(build.getResult(), TriggerNextBuildWrapper.this.triggerIfResult)) continue;
                    NodeParameterValue newNodeParam = new NodeParameterValue(origNodePram.getName(), nextNodes);
                    newPrams.add(newNodeParam);
                    String nextLabel = newNodeParam.getLabel();
                    if (nextLabel != null) {
                        LOGGER.log(Level.FINE, "schedule build for label {0}", nextLabel);
                        nextLabelCause = new NextLabelCause(nextLabel);
                        triggerNewBuild = true;
                        continue;
                    }
                    LOGGER.severe("can't trigger next build because next label could not be determined!");
                    continue;
                }
                newPrams.add(parameterValue);
            }
            if (triggerNewBuild) {
                build.getProject().scheduleBuild(0, nextLabelCause, new Action[]{new ParametersAction(newPrams)});
            }
            return true;
        }

        private boolean shouldScheduleNextJob(Result buildResult, String runIfResult) {
            if (runIfResult == null) {
                runIfResult = "allCases";
            }
            if (runIfResult.equals("allCases")) {
                return true;
            }
            if (runIfResult.equals("success")) {
                return buildResult == null || buildResult.isBetterOrEqualTo(Result.SUCCESS);
            }
            if (runIfResult.equals("unstable")) {
                return buildResult == null || buildResult.isBetterOrEqualTo(Result.UNSTABLE);
            }
            return false;
        }
    }
}

