/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.configfiles;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.Run;
import hudson.util.Secret;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.plugins.nodejs.configfiles.NPMRegistry;
import jenkins.plugins.nodejs.configfiles.Npmrc;
import org.apache.commons.codec.binary.Base64;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public final class RegistryHelper {
    private final Collection<NPMRegistry> registries;

    public RegistryHelper(@CheckForNull Collection<NPMRegistry> registries) {
        this.registries = registries;
    }

    public Map<String, StandardCredentials> resolveCredentials(Run<?, ?> build) {
        HashMap<String, StandardCredentials> registry2credential = new HashMap<String, StandardCredentials>();
        for (NPMRegistry registry : this.registries) {
            StandardCredentials c;
            String credentialsId = registry.getCredentialsId();
            if (credentialsId == null) continue;
            URL registryURL = RegistryHelper.toURL(registry.getUrl());
            List<Object> domainRequirements = Collections.emptyList();
            if (registryURL != null) {
                domainRequirements = Collections.singletonList(new HostnameRequirement(registryURL.getHost()));
            }
            if ((c = (StandardCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardCredentials.class, build, domainRequirements)) == null) continue;
            registry2credential.put(registry.getUrl(), c);
        }
        return registry2credential;
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="npm auth_token could not support base64 UTF-8 char encoding")
    public String fillRegistry(String npmrcContent, Map<String, StandardCredentials> registry2Credentials) {
        Npmrc npmrc = new Npmrc();
        npmrc.from(npmrcContent);
        for (NPMRegistry registry : this.registries) {
            StandardCredentials credentials = null;
            if (registry2Credentials.containsKey(registry.getUrl())) {
                credentials = registry2Credentials.get(registry.getUrl());
            }
            if (registry.isHasScopes()) {
                for (String scope : registry.getScopesAsList()) {
                    String registryPrefix = this.calculatePrefix(registry.getUrl());
                    String registryURL = this.fixURL(registry.getUrl());
                    npmrc.set(this.compose('@' + scope, "registry"), registryURL);
                    npmrc.set(this.compose(registryPrefix, "always-auth"), credentials != null);
                    if (credentials == null) continue;
                    if (credentials instanceof StandardUsernamePasswordCredentials) {
                        String passwordValue = Base64.encodeBase64String((byte[])Secret.toString((Secret)((StandardUsernamePasswordCredentials)credentials).getPassword()).getBytes());
                        npmrc.set(this.compose(registryPrefix, "username"), ((StandardUsernamePasswordCredentials)credentials).getUsername());
                        npmrc.set(this.compose(registryPrefix, "_password"), passwordValue);
                        continue;
                    }
                    if (!(credentials instanceof StringCredentials)) continue;
                    String tokenValue = Secret.toString((Secret)((StringCredentials)credentials).getSecret());
                    npmrc.set(this.compose(registryPrefix, "_authToken"), tokenValue);
                }
                continue;
            }
            npmrc.set("registry", registry.getUrl());
            npmrc.set("always-auth", credentials != null);
            if (credentials == null) continue;
            if (credentials instanceof StandardUsernamePasswordCredentials) {
                String authValue = ((StandardUsernamePasswordCredentials)credentials).getUsername() + ':' + Secret.toString((Secret)((StandardUsernamePasswordCredentials)credentials).getPassword());
                authValue = Base64.encodeBase64String((byte[])authValue.getBytes());
                npmrc.set("_auth", authValue);
                continue;
            }
            if (!(credentials instanceof StringCredentials)) continue;
            String tokenValue = Secret.toString((Secret)((StringCredentials)credentials).getSecret());
            npmrc.set("_authToken", tokenValue);
        }
        return npmrc.toString();
    }

    @Nonnull
    private String fixURL(@Nonnull String registryURL) {
        String url = registryURL;
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    @Nonnull
    public String calculatePrefix(@Nonnull String registryURL) {
        String trimmedURL = this.trimSlash(registryURL);
        URL url = RegistryHelper.toURL(trimmedURL);
        if (url == null) {
            throw new IllegalArgumentException("Invalid url " + registryURL);
        }
        return "//" + trimmedURL.substring((url.getProtocol() + "://").length()) + '/';
    }

    @Nonnull
    public String compose(@Nonnull String registryPrefix, @Nonnull String setting) {
        return registryPrefix + ":" + setting;
    }

    @Nonnull
    private String trimSlash(@Nonnull String url) {
        if (url != null && url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    @CheckForNull
    private static URL toURL(@Nullable String url) {
        URL result = null;
        String fixedURL = Util.fixEmptyAndTrim((String)url);
        if (fixedURL != null) {
            try {
                return new URL(fixedURL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return result;
    }
}

