/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import hudson.model.Computer;
import hudson.model.Node;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.tools.DetectionFailedException;

public enum Platform {
    LINUX("node", "npm", "bin"),
    WINDOWS("node.exe", "npm.cmd", ""),
    OSX("node", "npm", "bin"),
    SUNOS("node", "npm", "bin");

    public final String nodeFileName;
    public final String npmFileName;
    public final String binFolder;

    private Platform(String nodeFileName, String npmFileName, String binFolder) {
        this.nodeFileName = nodeFileName;
        this.npmFileName = npmFileName;
        this.binFolder = binFolder;
    }

    public boolean is(String line) {
        return line.contains(this.name());
    }

    public static Platform of(Node node) throws DetectionFailedException {
        try {
            Computer computer = node.toComputer();
            if (computer == null) {
                throw new DetectionFailedException(Messages.SystemTools_nodeNotAvailable(node.getDisplayName()));
            }
            return Platform.detect(computer.getSystemProperties());
        }
        catch (IOException | InterruptedException e) {
            throw new DetectionFailedException(Messages.SystemTools_failureOnProperties(), e);
        }
    }

    public static Platform current() throws DetectionFailedException {
        return Platform.detect(System.getProperties());
    }

    private static Platform detect(Map<Object, Object> systemProperties) throws DetectionFailedException {
        String arch = ((String)systemProperties.get("os.name")).toLowerCase(Locale.ENGLISH);
        if (arch.contains("linux")) {
            return LINUX;
        }
        if (arch.contains("windows")) {
            return WINDOWS;
        }
        if (arch.contains("mac")) {
            return OSX;
        }
        if (arch.contains("sunos")) {
            return SUNOS;
        }
        throw new DetectionFailedException(Messages.Platform_unknown(arch));
    }
}

