/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.cache;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Node;
import javax.annotation.Nonnull;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.cache.CacheLocationLocator;
import jenkins.plugins.nodejs.cache.CacheLocationLocatorDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class PerExecutorCacheLocationLocator
extends CacheLocationLocator {
    @DataBoundConstructor
    public PerExecutorCacheLocationLocator() {
    }

    @Override
    public FilePath locate(@Nonnull FilePath workspace) {
        Computer computer = workspace.toComputer();
        if (computer == null) {
            throw new IllegalStateException(Messages.NodeJSBuilders_nodeOffline());
        }
        Node node = computer.getNode();
        if (node == null) {
            throw new IllegalStateException(Messages.NodeJSBuilders_nodeOffline());
        }
        FilePath rootPath = node.getRootPath();
        Executor executor = Executor.currentExecutor();
        if (rootPath == null || executor == null) {
            return null;
        }
        return rootPath.child("npm-cache/" + executor.getNumber());
    }

    @Extension
    @Symbol(value={"executor"})
    public static class DescriptorImpl
    extends CacheLocationLocatorDescriptor {
        public String getDisplayName() {
            return Messages.ExecutorCacheLocationLocator_displayName();
        }
    }
}

