/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.tools.DetectionFailedException;
import org.apache.commons.io.output.NullOutputStream;

public enum CPU {
    i386,
    amd64,
    armv7l,
    armv6l,
    arm64;


    public static CPU of(@Nonnull Node node) throws DetectionFailedException {
        try {
            Computer computer = node.toComputer();
            if (computer == null) {
                throw new DetectionFailedException(Messages.SystemTools_nodeNotAvailable(node.getDisplayName()));
            }
            return CPU.detect(computer, computer.getSystemProperties());
        }
        catch (IOException | InterruptedException e) {
            throw new DetectionFailedException(Messages.SystemTools_failureOnProperties(), e);
        }
    }

    public static CPU current() throws DetectionFailedException {
        return CPU.detect(null, System.getProperties());
    }

    private static CPU detect(@Nullable Computer computer, Map<Object, Object> systemProperties) throws DetectionFailedException {
        String arch = ((String)systemProperties.get("os.arch")).toLowerCase(Locale.ENGLISH);
        if (arch.contains("amd64") || arch.contains("86_64")) {
            return amd64;
        }
        if (arch.contains("86")) {
            return i386;
        }
        if (arch.contains("arm")) {
            try {
                FilePath rootPath = new FilePath(computer != null ? computer.getChannel() : null, "/");
                arch = (String)rootPath.act((FilePath.FileCallable)new ArchitectureCallable());
            }
            catch (IOException | InterruptedException e) {
                throw new DetectionFailedException(Messages.CPU_unknown(arch), e);
            }
            switch (arch) {
                case "armv7l": {
                    return armv7l;
                }
                case "armv6l": {
                    return armv6l;
                }
                case "arm64": 
                case "aarch64": {
                    return arm64;
                }
            }
        }
        throw new DetectionFailedException(Messages.CPU_unknown(arch));
    }

    static class ArchitectureCallable
    extends MasterToSlaveFileCallable<String> {
        private static final long serialVersionUID = 1L;

        ArchitectureCallable() {
        }

        public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            Charset charset = Charset.defaultCharset();
            FilePath basePath = new FilePath(f);
            Launcher launcher = basePath.createLauncher((TaskListener)new StreamTaskListener((OutputStream)new NullOutputStream(), charset));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Proc starter = launcher.launch().cmdAsSingleString("uname -m").stdout((OutputStream)baos).start();
            int exitCode = starter.join();
            if (exitCode != 0) {
                throw new IOException("Fail to execute 'uname -m' because: " + baos.toString(charset.name()));
            }
            return new String(baos.toByteArray(), charset).trim();
        }
    }
}

