/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class NodeJSVersion
implements Comparable<NodeJSVersion> {
    private static final String MSG_INVALID_FORMAT = "invalid version \"{0}\": invalid format";
    private static final String MSG_NEGATIVE_NUMBER = "invalid version \"{0}\": negative number \"{1}\"";
    private static final String SEPARATOR = ".";
    private final int major;
    private final int minor;
    private final int micro;
    private transient String versionString;
    private transient int hash;
    public static final NodeJSVersion emptyVersion = new NodeJSVersion(0, 0, 0);

    public NodeJSVersion(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.validate();
    }

    public NodeJSVersion(String version) {
        int maj = 0;
        int min = 0;
        int mic = 0;
        String value = null;
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR, true);
            value = st.nextToken();
            maj = Integer.parseInt(value);
            if (st.hasMoreTokens()) {
                st.nextToken();
                value = st.nextToken();
                min = Integer.parseInt(value);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    value = st.nextToken();
                    mic = Integer.parseInt(value);
                    if (st.hasMoreTokens()) {
                        throw new IllegalArgumentException(MessageFormat.format(MSG_INVALID_FORMAT, version));
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid version \"" + version + "\": non-numeric \"" + value + "\"");
        }
        this.major = maj;
        this.minor = min;
        this.micro = mic;
        this.validate();
    }

    private void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException(MessageFormat.format(MSG_NEGATIVE_NUMBER, this.toString0(), this.major));
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException(MessageFormat.format(MSG_NEGATIVE_NUMBER, this.toString0(), this.minor));
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException(MessageFormat.format(MSG_NEGATIVE_NUMBER, this.toString0(), this.micro));
        }
    }

    public static NodeJSVersion parseVersion(String version) {
        String v = StringUtils.trimToNull((String)version);
        if (v == null) {
            return emptyVersion;
        }
        return new NodeJSVersion(v);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String toString() {
        return this.toString0();
    }

    String toString0() {
        if (this.versionString != null) {
            return this.versionString;
        }
        StringBuilder result = new StringBuilder(20);
        result.append(this.major);
        result.append(SEPARATOR);
        result.append(this.minor);
        result.append(SEPARATOR);
        result.append(this.micro);
        this.versionString = result.toString();
        return this.versionString;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h = 527;
        h = 31 * h + this.major;
        h = 31 * h + this.minor;
        this.hash = h = 31 * h + this.micro;
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NodeJSVersion)) {
            return false;
        }
        NodeJSVersion other = (NodeJSVersion)object;
        return this.major == other.major && this.minor == other.minor && this.micro == other.micro;
    }

    @Override
    public int compareTo(NodeJSVersion other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

