/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import hudson.model.Computer;
import hudson.model.Node;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.plugins.nodejs.tools.DetectionFailedException;

public enum CPU {
    i386,
    amd64;


    public static CPU of(@Nonnull Node node) throws IOException, InterruptedException {
        Computer computer = node.toComputer();
        if (computer == null) {
            throw new DetectionFailedException("Node offline");
        }
        return CPU.detect(computer.getSystemProperties());
    }

    public static CPU current() throws DetectionFailedException {
        return CPU.detect(System.getProperties());
    }

    private static CPU detect(Map<Object, Object> systemProperties) throws DetectionFailedException {
        String arch = ((String)systemProperties.get("os.arch")).toLowerCase(Locale.ENGLISH);
        if (arch.contains("amd64") || arch.contains("86_64")) {
            return amd64;
        }
        if (arch.contains("86")) {
            return i386;
        }
        throw new DetectionFailedException("Unknown CPU architecture: " + arch);
    }
}

