/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import hudson.tools.DownloadFromUrlInstaller;
import jenkins.plugins.nodejs.tools.CPU;
import jenkins.plugins.nodejs.tools.NodeJSVersion;
import jenkins.plugins.nodejs.tools.NodeJSVersionRange;
import jenkins.plugins.nodejs.tools.Platform;
import jenkins.plugins.nodejs.tools.pathresolvers.LatestInstallerPathResolver;

public interface InstallerPathResolver {
    public String resolvePathFor(String var1, Platform var2, CPU var3);

    public static class Factory {
        public static InstallerPathResolver findResolverFor(DownloadFromUrlInstaller.Installable installable) {
            if (Factory.isVersionBlacklisted(installable.id)) {
                throw new IllegalArgumentException("Provided version (" + installable.id + ") installer structure not (yet) supported !");
            }
            return new LatestInstallerPathResolver();
        }

        public static boolean isVersionBlacklisted(String version) {
            NodeJSVersion nodeJSVersion = NodeJSVersion.parseVersion(version);
            return new NodeJSVersionRange("[0, 0.8.6)").includes(nodeJSVersion) || NodeJSVersion.parseVersion("0.9.0").equals(nodeJSVersion);
        }
    }
}

