/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.configfiles;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.configfiles.NPMRegistry;
import jenkins.plugins.nodejs.configfiles.VerifyConfigProviderException;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.kohsuke.stapler.DataBoundConstructor;

public class NPMConfig
extends Config {
    private static final long serialVersionUID = 1L;
    private final List<NPMRegistry> registries;

    @DataBoundConstructor
    public NPMConfig(@Nonnull String id, String name, String comment, String content, @Nonnull String providerId, List<NPMRegistry> registries) {
        super(id, Util.fixEmptyAndTrim((String)name), Util.fixEmptyAndTrim((String)comment), Util.fixEmptyAndTrim((String)content), providerId);
        this.registries = registries == null ? new ArrayList(3) : registries;
    }

    public List<NPMRegistry> getRegistries() {
        return this.registries;
    }

    public void doVerify() throws VerifyConfigProviderException {
        NPMRegistry globalRegistry = null;
        for (NPMRegistry registry : this.registries) {
            registry.doVerify();
            if (registry.isHasScopes()) continue;
            if (globalRegistry != null) {
                throw new VerifyConfigProviderException(Messages.NPMConfig_verifyTooGlobalRegistry());
            }
            globalRegistry = registry;
        }
    }

    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.getActiveInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    public static class NPMConfigProvider
    extends AbstractConfigProviderImpl {
        public NPMConfigProvider() {
            this.load();
        }

        public ContentType getContentType() {
            return null;
        }

        public String getDisplayName() {
            return Messages.NPMConfig_displayName();
        }

        public Config newConfig(@Nonnull String configId) {
            return new NPMConfig(configId, "MyNpmrcConfig", "user config", this.loadTemplateContent(), this.getProviderId(), null);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected String loadTemplateContent() {
            try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("template.npmrc");){
                String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
                return string;
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

