/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import jenkins.plugins.nodejs.NodeJSPlugin;
import jenkins.plugins.nodejs.tools.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeJSInstallation
extends ToolInstallation
implements EnvironmentSpecific<NodeJSInstallation>,
NodeSpecific<NodeJSInstallation>,
Serializable {
    private static final String WINDOWS_NODEJS_COMMAND = "node.exe";
    private static final String UNIX_NODEJS_COMMAND = "node";
    private final String nodeJSHome = super.getHome();

    @DataBoundConstructor
    public NodeJSInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, NodeJSInstallation.launderHome(home), properties);
    }

    private static String launderHome(String home) {
        if (home.endsWith("/") || home.endsWith("\\")) {
            return home.substring(0, home.length() - 1);
        }
        return home;
    }

    public String getHome() {
        if (this.nodeJSHome != null) {
            return this.nodeJSHome;
        }
        return super.getHome();
    }

    public NodeJSInstallation forEnvironment(EnvVars environment) {
        return new NodeJSInstallation(this.getName(), environment.expand(this.nodeJSHome), this.getProperties().toList());
    }

    public NodeJSInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new NodeJSInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public String getExecutable(Launcher launcher) throws InterruptedException, IOException {
        return (String)launcher.getChannel().call((Callable)new Callable<String, IOException>(){

            public String call() throws IOException {
                File exe = NodeJSInstallation.this.getExeFile();
                if (exe.exists()) {
                    return exe.getPath();
                }
                return null;
            }
        });
    }

    private File getExeFile() {
        String execName = Functions.isWindows() ? WINDOWS_NODEJS_COMMAND : UNIX_NODEJS_COMMAND;
        String nodeJSHome = Util.replaceMacro((String)this.nodeJSHome, (Map)EnvVars.masterEnvVars);
        return new File(nodeJSHome, "bin/" + execName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<NodeJSInstallation> {
        public String getDisplayName() {
            return Messages.installer_displayName();
        }

        public NodeJSInstallation[] getInstallations() {
            return NodeJSPlugin.instance().getInstallations();
        }

        public void setInstallations(NodeJSInstallation ... installations) {
            NodeJSPlugin.instance().setInstallations(installations);
        }
    }
}

