/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import hudson.tools.DownloadFromUrlInstaller;
import jenkins.plugins.nodejs.tools.NodeJSInstaller;
import jenkins.plugins.nodejs.tools.NodeJSVersion;
import jenkins.plugins.nodejs.tools.pathresolvers.LatestInstallerPathResolver;

public interface InstallerPathResolver {
    public String resolvePathFor(String var1, NodeJSInstaller.Platform var2, NodeJSInstaller.CPU var3);

    public String extractArchiveIntermediateDirectoryName(String var1);

    public static class Factory {
        public static InstallerPathResolver findResolverFor(DownloadFromUrlInstaller.Installable installable) {
            if (Factory.isVersionBlacklisted(installable.id)) {
                throw new IllegalArgumentException("Provided version (" + installable.id + ") installer structure not (yet) supported !");
            }
            return new LatestInstallerPathResolver();
        }

        public static boolean isVersionBlacklisted(String version) {
            NodeJSVersion nodeJSVersion = new NodeJSVersion(version);
            return nodeJSVersion.isLowerThan("0.8.6") || "0.9.0".equals(version);
        }
    }
}

