/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.tasks.Messages;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.plugins.nodejs.NodeJSPlugin;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeJsCommandInterpreter
extends Builder {
    private String command;
    private String nodeJSInstallationName;
    @Extension
    public static final NodeJsDescriptor DESCRIPTOR = new NodeJsDescriptor();

    @DataBoundConstructor
    public NodeJsCommandInterpreter(String command, String nodeJSInstallationName) {
        this.command = command;
        this.nodeJSInstallationName = nodeJSInstallationName;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        return this.perform(build, launcher, (TaskListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws InterruptedException {
        FilePath ws = build.getWorkspace();
        if (ws == null) {
            Node node = build.getBuiltOn();
            if (node == null) {
                throw new NullPointerException("no such build node: " + build.getBuiltOnStr());
            }
            throw new NullPointerException("no workspace from node " + node + " which is computer " + node.toComputer() + " and has channel " + node.getChannel());
        }
        FilePath script = null;
        try {
            int r;
            try {
                script = this.createScriptFile(ws);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToProduceScript()));
                boolean bl = false;
                try {
                    if (script != null) {
                        script.delete();
                    }
                }
                catch (IOException e2) {
                    Util.displayIOException((IOException)e2, (TaskListener)listener);
                    e2.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToDelete((Object)script)));
                }
                catch (Exception e3) {
                    e3.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToDelete((Object)script)));
                }
                return bl;
            }
            try {
                EnvVars envVars = build.getEnvironment(listener);
                for (Map.Entry e : build.getBuildVariables().entrySet()) {
                    envVars.put((String)e.getKey(), (String)e.getValue());
                }
                ArgumentListBuilder args = new ArgumentListBuilder();
                NodeJSInstallation selectedInstallation = NodeJSPlugin.instance().findInstallationByName(this.nodeJSInstallationName);
                selectedInstallation = selectedInstallation.forNode(build.getBuiltOn(), listener);
                selectedInstallation = selectedInstallation.forEnvironment(envVars);
                String exe = selectedInstallation.getExecutable(launcher);
                args.add(exe);
                args.add(script.getRemote());
                r = launcher.launch().cmds(args).envs((Map)envVars).stdout(listener).pwd(ws).join();
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError(Messages.CommandInterpreter_CommandFailed()));
                r = -1;
            }
            boolean bl = r == 0;
            return bl;
        }
        finally {
            try {
                if (script != null) {
                    script.delete();
                }
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToDelete((Object)script)));
            }
            catch (Exception e) {
                e.printStackTrace(listener.fatalError(Messages.CommandInterpreter_UnableToDelete((Object)script)));
            }
        }
    }

    public FilePath createScriptFile(@Nonnull FilePath dir) throws IOException, InterruptedException {
        return dir.createTextTempFile("hudson", ".js", this.command, false);
    }

    public String getCommand() {
        return this.command;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NodeJsDescriptor
    extends Descriptor<Builder> {
        private NodeJsDescriptor() {
            super(NodeJsCommandInterpreter.class);
        }

        public Builder newInstance(StaplerRequest request, JSONObject json) {
            return new NodeJsCommandInterpreter(json.getString("nodejs_command"), json.getString("nodejs_installationName"));
        }

        public String getDisplayName() {
            return "Execute NodeJS script";
        }

        public NodeJSInstallation[] getInstallations() {
            return NodeJSPlugin.instance().getInstallations();
        }

        public String getHelpFile() {
            return "/plugin/nodejs/help.html";
        }
    }
}

