/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.utility;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.io.IOUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.http.HttpResponse;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AppCommon {
    public static List<String> getNames(Class<? extends Enum<?>> e) {
        String[] enumNames = Arrays.toString(e.getEnumConstants()).replaceAll("^.|.$", "").split(", ");
        return Arrays.asList(enumNames);
    }

    public static boolean isUrlValid(String url) {
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes, 8L);
        return urlValidator.isValid(url);
    }

    public static boolean isValidEmailAddress(String email) {
        boolean result = true;
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    public static boolean isGUIDValid(String guid) {
        try {
            if (guid == null) {
                return false;
            }
            UUID.fromString(guid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
            return true;
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
    }

    public static URL getBaseURL(String url) throws MalformedURLException {
        return new URL(new URL(url), "/");
    }

    public static String mapToQueryString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            try {
                String key = entry.getKey();
                String value = entry.getValue();
                stringBuilder.append(key != null ? URLEncoder.encode(key, "UTF-8") : "");
                stringBuilder.append("=");
                stringBuilder.append(value != null ? URLEncoder.encode(value, "UTF-8") : "");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("This method requires UTF-8 encoding support", e);
            }
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> queryStringToMap(String input) {
        String[] nameValuePairs;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String nameValuePair : nameValuePairs = input.split("&")) {
            String[] nameValue = nameValuePair.split("=");
            try {
                map.put(URLDecoder.decode(nameValue[0], "UTF-8"), nameValue.length > 1 ? URLDecoder.decode(nameValue[1], "UTF-8") : "");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("This method requires UTF-8 encoding support", e);
            }
        }
        return map;
    }

    public static Object parseJsonValue(String Data, String key) throws ParseException {
        Object value;
        JSONParser parser = new JSONParser();
        Object parsedData = parser.parse(Data);
        if (parsedData instanceof JSONArray) {
            JSONArray array = (JSONArray)parsedData;
            JSONObject object = (JSONObject)array.get(0);
            value = object.get((Object)key);
        } else {
            JSONObject obj = (JSONObject)parsedData;
            value = obj.get((Object)key);
        }
        return value;
    }

    public static String parseResponseToString(HttpResponse response) throws IOException {
        return IOUtils.toString((InputStream)response.getEntity().getContent());
    }
}

