/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.plugin;

import com.netsparker.cloud.model.ScanRequest;
import com.netsparker.cloud.model.ScanRequestResult;
import com.netsparker.cloud.model.ScanType;
import com.netsparker.cloud.model.VCSCommit;
import com.netsparker.cloud.model.WebsiteModel;
import com.netsparker.cloud.model.WebsiteModelRequest;
import com.netsparker.cloud.model.WebsiteProfileModel;
import com.netsparker.cloud.plugin.Messages;
import com.netsparker.cloud.plugin.NCScanResultAction;
import com.netsparker.cloud.plugin.NCScanSCMAction;
import com.netsparker.cloud.utility.AppCommon;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class NCScanBuilder
extends Builder
implements SimpleBuildStep {
    private String ncScanType;
    private String ncWebsiteId;
    private String ncProfileId;
    private String ncApiToken;
    private String ncServerURL;

    @DataBoundConstructor
    public NCScanBuilder(String ncScanType, String ncWebsiteId) {
        this.ncScanType = ncScanType == null ? "" : ncScanType;
        this.ncWebsiteId = ncWebsiteId == null ? "" : ncWebsiteId;
    }

    public String getNcScanType() {
        return this.ncScanType;
    }

    public void setNcScanType(String ncScanType) {
        this.ncScanType = ncScanType;
    }

    public String getNcWebsiteId() {
        return this.ncWebsiteId;
    }

    public void setNcWebsiteId(String ncTargetURL) {
        this.ncWebsiteId = ncTargetURL;
    }

    public String getNcProfileId() {
        return this.ncProfileId;
    }

    @DataBoundSetter
    public void setNcProfileId(String ncProfileId) {
        this.ncProfileId = ncProfileId;
    }

    public String getNcServerURL() {
        return this.ncServerURL;
    }

    @DataBoundSetter
    public void setNcServerURL(String ncServerURL) {
        this.ncServerURL = ncServerURL;
    }

    public String getNcApiToken() {
        return this.ncApiToken;
    }

    @DataBoundSetter
    public void setNcApiToken(String ncApiToken) {
        this.ncApiToken = ncApiToken;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        this.logInfo("Scan step created...", listener);
        NCScanSCMAction scmAction = (NCScanSCMAction)build.getAction(NCScanSCMAction.class);
        VCSCommit commit = scmAction == null ? VCSCommit.empty(build) : scmAction.getVcsCommit();
        try {
            this.ScanRequestHandler(build, commit, listener);
        }
        catch (Exception e) {
            build.addAction((Action)new NCScanResultAction(ScanRequestResult.errorResult("Scan Request Failed:: " + e.getMessage())));
            throw new IOException(e);
        }
    }

    private void ScanRequestHandler(Run<?, ?> build, VCSCommit commit, TaskListener listener) throws Exception {
        DescriptorImpl descriptor = this.getDescriptor();
        String ncServerURL = StringUtils.isBlank((String)this.getNcServerURL()) ? descriptor.getNcServerURL() : this.getNcServerURL();
        String ncApiToken = StringUtils.isBlank((String)this.getNcApiToken()) ? descriptor.getNcApiToken() : this.getNcApiToken();
        commit.setRootURL(descriptor.getRootURL());
        ScanRequest scanRequest = new ScanRequest(ncServerURL, ncApiToken, this.ncScanType, this.ncWebsiteId, this.ncProfileId, commit);
        this.logInfo("Requesting scan...", listener);
        HttpResponse scanRequestResponse = scanRequest.scanRequest();
        this.logInfo("Response status code: " + scanRequestResponse.getStatusLine().getStatusCode(), listener);
        ScanRequestResult scanRequestResult = new ScanRequestResult(scanRequestResponse, ncServerURL, ncApiToken);
        build.replaceAction((Action)new NCScanResultAction(scanRequestResult));
        if (scanRequestResult.getHttpStatusCode() == 201 && !scanRequestResult.isError()) {
            this.ScanRequestSuccessHandler(scanRequestResult, listener);
        } else {
            this.ScanRequestFailureHandler(scanRequestResult, listener);
        }
    }

    private void ScanRequestSuccessHandler(ScanRequestResult scanRequestResult, TaskListener listener) throws IOException {
        this.logInfo("Scan requested successfully.", listener);
    }

    private void ScanRequestFailureHandler(ScanRequestResult scanRequestResult, TaskListener listener) throws Exception {
        this.logError("Scan request failed. Error Message: " + scanRequestResult.getErrorMessage(), listener);
        throw new Exception("Netsparker Cloud Plugin: Failed to start the scan. Response status code: " + scanRequestResult.getHttpStatusCode());
    }

    private void logInfo(String message, TaskListener listener) {
        listener.getLogger().println("> Netsparker Cloud Plugin: " + message);
    }

    private void logError(String message, TaskListener listener) {
        listener.error("> Netsparker Cloud Plugin: " + message);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"NCScanBuilder"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private long lastEditorId = 0L;
        private ArrayList<WebsiteModel> websiteModels = new ArrayList();
        private String ncServerURL;
        private String ncApiToken;
        private String rootURL;

        public DescriptorImpl() {
            super(NCScanBuilder.class);
            this.load();
        }

        public String getNcServerURL() {
            return this.ncServerURL;
        }

        public void setNcServerURL(String ncServerURL) {
            this.ncServerURL = ncServerURL;
        }

        public String getNcApiToken() {
            return this.ncApiToken;
        }

        public void setNcApiToken(String ncApiToken) {
            this.ncApiToken = ncApiToken;
        }

        public String getRootURL() {
            return this.rootURL;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.HelloWorldBuilder_DescriptorImpl_DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this);
            this.ncServerURL = formData.getString("ncServerURL");
            this.ncApiToken = formData.getString("ncApiToken");
            this.rootURL = Jenkins.getInstance().getRootUrl();
            this.save();
            return super.configure(req, formData);
        }

        public String getConfigPage() {
            try {
                this.doValidateAPI(this.ncServerURL, this.ncApiToken);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.getConfigPage();
        }

        @JavaScriptMethod
        public synchronized String createEditorId() {
            return String.valueOf(this.lastEditorId++);
        }

        public ListBoxModel doFillNcScanTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("-- Please select a scan type --", "");
            model.add("Incremental", "Incremental");
            model.add("Full (With primary profile)", "FullWithPrimaryProfile");
            model.add("Full (With selected profile)", "FullWithSelectedProfile");
            return model;
        }

        public ListBoxModel doFillNcWebsiteIdItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("-- Please select a website --", "");
            for (WebsiteModel websiteModel : this.websiteModels) {
                model.add(websiteModel.getDisplayName(), websiteModel.getId());
            }
            return model;
        }

        public ListBoxModel doFillNcProfileIdItems(@QueryParameter String ncWebsiteId) {
            ArrayList<WebsiteProfileModel> websiteProfileModels;
            WebsiteModel websiteModel = new WebsiteModel();
            for (WebsiteModel wm : this.websiteModels) {
                if (ncWebsiteId == null || !wm.getId().equals(ncWebsiteId)) continue;
                websiteModel = wm;
                break;
            }
            String placeholderText = (websiteProfileModels = websiteModel.getProfiles()).isEmpty() ? "-- No profile found --" : "-- Please select a profile name --";
            ListBoxModel model = new ListBoxModel();
            model.add(placeholderText, "");
            for (WebsiteProfileModel websiteProfileModel : websiteProfileModels) {
                model.add(websiteProfileModel.getName(), websiteProfileModel.getId());
            }
            return model;
        }

        public FormValidation doValidateAPI(@QueryParameter String ncServerURL, @QueryParameter String ncApiToken) {
            try {
                WebsiteModelRequest websiteModelRequest = new WebsiteModelRequest(ncServerURL, ncApiToken);
                HttpResponse response = websiteModelRequest.getPluginWebSiteModels();
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    this.websiteModels = new ArrayList();
                    this.websiteModels.addAll(websiteModelRequest.getWebsiteModels());
                    return FormValidation.ok((String)"Successfully connected to the Netsparker Cloud.");
                }
                return FormValidation.error((String)("Netsparker Cloud rejected the request. HTTP status code: " + statusCode));
            }
            catch (Exception e) {
                return FormValidation.error((String)("Failed to connect to the Netsparker Cloud. : " + e.toString()));
            }
        }

        public FormValidation doCheckNcServerURL(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_missingApiURL());
            }
            if (!AppCommon.isUrlValid(value)) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_invalidApiURL());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNcApiToken(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_missingApiToken());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNcScanType(@QueryParameter String value) {
            try {
                ScanType.valueOf(value);
            }
            catch (Exception ex) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_invalidScanType());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNcWebsiteID(@QueryParameter String value) {
            if (!AppCommon.isGUIDValid(value)) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_invalidWebsiteId());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNcProfileId(@QueryParameter String value, @QueryParameter String ncScanType) {
            boolean isRequired;
            try {
                ScanType type = ScanType.valueOf(ncScanType);
                isRequired = type != ScanType.FullWithPrimaryProfile;
            }
            catch (Exception ex) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_invalidProfileId());
            }
            if (isRequired && !AppCommon.isGUIDValid(value)) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_invalidProfileId());
            }
            return FormValidation.ok();
        }
    }
}

