/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.model;

import com.netsparker.cloud.model.ScanRequestBase;
import com.netsparker.cloud.model.WebsiteModel;
import com.netsparker.cloud.model.WebsiteProfileModel;
import com.netsparker.cloud.utility.AppCommon;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class WebsiteModelRequest
extends ScanRequestBase {
    private ArrayList<WebsiteModel> websiteModels = new ArrayList();
    private HttpResponse response;
    private final URI pluginWebSiteModelsUri = new URL(this.ApiURL, "api/1.0/scans/PluginWebSiteModels").toURI();

    public WebsiteModelRequest(String apiURL, String apiToken) throws MalformedURLException, NullPointerException, URISyntaxException {
        super(apiURL, apiToken);
    }

    public ArrayList<WebsiteModel> getWebsiteModels() {
        return this.websiteModels;
    }

    public HttpResponse getPluginWebSiteModels() throws IOException, ParseException {
        HttpClient httpClient = this.getHttpClient();
        HttpGet httpGet = new HttpGet(this.pluginWebSiteModelsUri);
        httpGet.setHeader("Accept", "application/json");
        httpGet.setHeader("Authorization", this.getAuthHeader());
        this.response = httpClient.execute((HttpUriRequest)httpGet);
        if (this.response.getStatusLine().getStatusCode() == 200) {
            this.parseWebsiteData();
        }
        return this.response;
    }

    private void parseWebsiteData() throws ParseException, IOException {
        String data = AppCommon.parseResponseToString(this.response);
        JSONParser parser = new JSONParser();
        Object jsonData = parser.parse(data);
        JSONArray WebsiteModelObjects = (JSONArray)jsonData;
        this.websiteModels = new ArrayList();
        for (Object wmo : WebsiteModelObjects) {
            if (!(wmo instanceof JSONObject)) continue;
            JSONObject websiteModelObject = (JSONObject)wmo;
            WebsiteModel websiteModel = new WebsiteModel();
            websiteModel.setId((String)websiteModelObject.get((Object)"Id"));
            websiteModel.setName((String)websiteModelObject.get((Object)"Name"));
            websiteModel.setUrl((String)websiteModelObject.get((Object)"Url"));
            JSONArray WebsiteProfileModelObjects = (JSONArray)websiteModelObject.get((Object)"WebsiteProfiles");
            ArrayList<WebsiteProfileModel> profiles = new ArrayList<WebsiteProfileModel>();
            for (Object wmpo : WebsiteProfileModelObjects) {
                JSONObject websiteProfileModelObject = (JSONObject)wmpo;
                WebsiteProfileModel websiteProfileModel = new WebsiteProfileModel();
                websiteProfileModel.setId((String)websiteProfileModelObject.get((Object)"Id"));
                websiteProfileModel.setName((String)websiteProfileModelObject.get((Object)"Name"));
                profiles.add(websiteProfileModel);
            }
            websiteModel.setProfiles(profiles);
            this.websiteModels.add(websiteModel);
        }
    }
}

