/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.model;

import com.netsparker.cloud.model.ScanReport;
import com.netsparker.cloud.model.ScanRequestBase;
import com.netsparker.cloud.utility.AppCommon;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.simple.parser.ParseException;

public class ScanRequestResult
extends ScanRequestBase {
    private String scanReportEndpoint;
    private final int httpStatusCode;
    private String data;
    private String scanTaskID;
    private boolean isError;
    private String errorMessage;
    private ScanReport report = null;
    private Date previousRequestTime;

    public static ScanRequestResult errorResult(String errorMessage) {
        return new ScanRequestResult(errorMessage);
    }

    private ScanRequestResult(String errorMessage) {
        this.errorMessage = errorMessage;
        this.httpStatusCode = 0;
        this.isError = true;
        this.data = "";
    }

    public ScanRequestResult(HttpResponse response, String apiURL, String apiToken) throws MalformedURLException, URISyntaxException {
        super(apiURL, apiToken);
        this.httpStatusCode = response.getStatusLine().getStatusCode();
        boolean bl = this.isError = this.httpStatusCode != 201;
        if (!this.isError) {
            try {
                this.data = AppCommon.parseResponseToString(response);
                boolean bl2 = this.isError = (Boolean)AppCommon.parseJsonValue(this.data, "IsValid") == false;
                if (!this.isError) {
                    this.scanTaskID = (String)AppCommon.parseJsonValue(this.data, "ScanTaskId");
                } else {
                    this.errorMessage = (String)AppCommon.parseJsonValue(this.data, "ErrorMessage");
                }
            }
            catch (ParseException ex) {
                this.isError = true;
                this.errorMessage = "Scan request result is not parsable::: " + ex.toString();
            }
            catch (IOException ex) {
                this.isError = true;
                this.errorMessage = "Scan request result is not readable::: " + ex.toString();
            }
        }
        String scanReportRelativeUrl = "api/1.0/scans/report/";
        URI scanReportEndpointUri = new URL(this.ApiURL, scanReportRelativeUrl).toURI();
        HashMap<String, String> queryparams = new HashMap<String, String>();
        queryparams.put("Type", "ExecutiveSummary");
        queryparams.put("Format", "Html");
        queryparams.put("Id", this.scanTaskID);
        this.scanReportEndpoint = scanReportEndpointUri.toString() + "?" + AppCommon.mapToQueryString(queryparams);
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isReportGenerated() {
        if (this.isError()) {
            return false;
        }
        if (this.isReportAvailable()) {
            return true;
        }
        if (this.canAskForReportFromNCCloud()) {
            try {
                ScanReport report = this.getReport();
                return report.isReportGenerated();
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    private boolean canAskForReportFromNCCloud() {
        Date now = new Date();
        boolean isTimeThresholdPassed = this.previousRequestTime == null || now.getTime() - this.previousRequestTime.getTime() >= 60000L;
        return !this.isReportAvailable() && isTimeThresholdPassed;
    }

    private boolean isReportAvailable() {
        return this.report != null && this.report.isReportGenerated();
    }

    public ScanReport getReport() {
        if (this.canAskForReportFromNCCloud()) {
            ScanReport reportFromNcCloud = this.getReportFromNcCloud();
            this.previousRequestTime = new Date();
            return reportFromNcCloud;
        }
        return this.report;
    }

    private ScanReport getReportFromNcCloud() {
        ScanReport report;
        if (!this.isError) {
            try {
                HttpClient httpClient = this.getHttpClient();
                HttpGet httpGet = new HttpGet(this.scanReportEndpoint);
                httpGet.setHeader("Authorization", this.getAuthHeader());
                HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                report = new ScanReport(response, this.scanReportEndpoint);
            }
            catch (IOException ex) {
                String reportRequestErrorMessage = "Report result is not readable::: " + ex.toString();
                report = new ScanReport(false, "", true, reportRequestErrorMessage, this.scanReportEndpoint);
            }
        } else {
            report = new ScanReport(true, this.errorMessage, false, "", this.scanReportEndpoint);
        }
        this.report = report;
        return report;
    }
}

