/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.model;

import com.netsparker.cloud.model.ScanRequestBase;
import com.netsparker.cloud.model.ScanType;
import com.netsparker.cloud.model.VCSCommit;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;

public class ScanRequest
extends ScanRequestBase {
    public final ScanType scanType;
    public final String websiteId;
    public final String profileId;
    public final VCSCommit vcsCommit;
    public final URI scanUri;
    public final URI testUri;

    public ScanRequest(String apiURL, String apiToken, String scanType, String websiteId, String profileId, VCSCommit vcsCommit) throws MalformedURLException, NullPointerException, URISyntaxException {
        super(apiURL, apiToken);
        this.scanType = ScanType.valueOf(scanType);
        this.websiteId = websiteId;
        this.profileId = profileId;
        this.vcsCommit = vcsCommit;
        this.scanUri = new URL(this.ApiURL, "api/1.0/scans/CreateFromPluginScanRequest").toURI();
        this.testUri = new URL(this.ApiURL, "api/1.0/scans/VerifyPluginScanRequest").toURI();
    }

    public HttpResponse scanRequest() throws IOException {
        HttpClient client = this.getHttpClient();
        HttpPost httpPost = new HttpPost(this.scanUri);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Authorization", this.getAuthHeader());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.setScanParams(params);
        this.vcsCommit.addVcsCommitInfo(params);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        return response;
    }

    public HttpResponse testRequest() throws IOException {
        HttpClient client = this.getHttpClient();
        HttpPost httpPost = new HttpPost(this.testUri);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Authorization", this.getAuthHeader());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.setScanParams(params);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        return response;
    }

    private void setScanParams(List<NameValuePair> params) {
        switch (this.scanType) {
            case Incremental: {
                params.add((NameValuePair)new BasicNameValuePair("WebsiteId", this.websiteId));
                params.add((NameValuePair)new BasicNameValuePair("ProfileId", this.profileId));
                params.add((NameValuePair)new BasicNameValuePair("ScanType", "Incremental"));
                break;
            }
            case FullWithPrimaryProfile: {
                params.add((NameValuePair)new BasicNameValuePair("WebsiteId", this.websiteId));
                params.add((NameValuePair)new BasicNameValuePair("ScanType", "FullWithPrimaryProfile"));
                break;
            }
            case FullWithSelectedProfile: {
                params.add((NameValuePair)new BasicNameValuePair("WebsiteId", this.websiteId));
                params.add((NameValuePair)new BasicNameValuePair("ProfileId", this.profileId));
                params.add((NameValuePair)new BasicNameValuePair("ScanType", "FullWithSelectedProfile"));
            }
        }
    }
}

