/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.model;

import com.netsparker.cloud.utility.AppCommon;
import org.apache.http.HttpResponse;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ScanReport {
    private final HttpResponse reportRequestResponse;
    private final boolean scanRequestHasError;
    private final String scanRequestErrorMessage;
    private final boolean reportRequestHasError;
    private final String reportRequestErrorMessage;
    private final String requestURI;

    public ScanReport(HttpResponse reportRequestResponse, String requestURI) {
        this.reportRequestResponse = reportRequestResponse;
        this.scanRequestHasError = false;
        this.scanRequestErrorMessage = "";
        this.reportRequestHasError = false;
        this.reportRequestErrorMessage = "";
        this.requestURI = requestURI;
    }

    public ScanReport(boolean scanRequestHasError, String scanRequestErrorMessage, boolean reportRequestHasError, String reportRequestErrorMessage, String requestURI) {
        this.reportRequestResponse = null;
        this.scanRequestHasError = scanRequestHasError;
        this.scanRequestErrorMessage = scanRequestErrorMessage;
        this.reportRequestHasError = reportRequestHasError;
        this.reportRequestErrorMessage = reportRequestErrorMessage;
        this.requestURI = requestURI;
    }

    public boolean isReportGenerated() {
        try {
            return this.getContentType().equalsIgnoreCase("text/html");
        }
        catch (Exception ex) {
            return false;
        }
    }

    private String getContentType() {
        return this.reportRequestResponse.getHeaders("Content-Type")[0].getValue();
    }

    public String getContent() {
        String content = "";
        try {
            if (this.scanRequestHasError) {
                content = this.ExceptionContent(content, this.scanRequestErrorMessage);
            } else if (this.reportRequestHasError) {
                content = this.ExceptionContent(content, this.reportRequestErrorMessage);
            } else {
                String contentData = AppCommon.parseResponseToString(this.reportRequestResponse);
                if (this.isReportGenerated()) {
                    content = contentData;
                } else {
                    JSONParser parser = new JSONParser();
                    JSONObject obj = (JSONObject)parser.parse(contentData);
                    content = (String)obj.get((Object)"Message");
                }
            }
        }
        catch (ParseException ex) {
            content = this.ExceptionContent("Report result is not parsable.", ex.toString());
        }
        catch (Exception ex) {
            content = this.ExceptionContent(content, ex.toString());
        }
        return content;
    }

    private String ExceptionContent(String content, String ExceptionMessage) {
        content = content != null && !content.isEmpty() ? "<p>" + content + "</p>" : "<p>Something went wrong.</p>";
        if (this.requestURI != null) {
            content = content + "<p>Request URL: " + this.requestURI + "</p>";
        }
        if (this.reportRequestResponse != null && this.reportRequestResponse.getStatusLine() != null) {
            content = content + "<p>HttpStatusCode: " + this.reportRequestResponse.getStatusLine().getStatusCode() + "</p>";
        }
        if (ExceptionMessage != null) {
            content = content + "<p>Exception Message:: " + ExceptionMessage + "</p>";
        }
        return content;
    }
}

