/*
 * Decompiled with CFR 0.152.
 */
package com.deepshiftlabs.nerrvana;

import com.deepshiftlabs.nerrvana.Logger;
import com.deepshiftlabs.nerrvana.UserMessageLevel;
import com.deepshiftlabs.nerrvana.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserMessage {
    public UserMessageLevel level;
    public String txt;
    public Date created_time;

    public UserMessage(Node node, UserMessageLevel level) throws Exception {
        this.txt = Utils.getUniqueChildNodeValue(node, "txt");
        String s = Utils.getUniqueChildNodeValue(node, "created_time");
        try {
            this.created_time = new Date(Long.parseLong(s) * 1000L);
        }
        catch (Exception e) {
            Logger.infoln("Invalid 'message.created_time' value: " + s);
        }
        this.level = level;
    }

    public UserMessage(String txt, Date created_time) throws Exception {
        this.txt = txt;
        this.created_time = created_time;
    }

    public String getTxt() {
        return this.txt;
    }

    public String getCreatedTime() {
        return this.created_time == null ? "<unknown time>" : this.created_time.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("USER-MESSAGE[");
        if (this.created_time == null) {
            sb.append("<unknown time>\n");
        } else {
            sb.append("<").append(this.created_time.toString()).append(">\n");
        }
        sb.append(this.txt.trim());
        sb.append("\n]END\n");
        return sb.toString();
    }

    public static SortedMap<UserMessageLevel, List<UserMessage>> getAllUserMessages(Document doc) throws Exception {
        TreeMap<UserMessageLevel, List<UserMessage>> messageMap = new TreeMap<UserMessageLevel, List<UserMessage>>();
        for (UserMessageLevel level : UserMessageLevel.values()) {
            ArrayList<UserMessage> listOfMessages = null;
            NodeList listOfMessageContainers = doc.getElementsByTagName(level.name().toLowerCase());
            if (listOfMessageContainers != null && listOfMessageContainers.getLength() > 0) {
                for (int i = 0; i < listOfMessageContainers.getLength(); ++i) {
                    Node messageContainer = listOfMessageContainers.item(i);
                    if (messageContainer.getChildNodes() == null || messageContainer.getChildNodes().getLength() <= 0) continue;
                    NodeList listOfChildNodes = messageContainer.getChildNodes();
                    for (int j = 0; j < listOfChildNodes.getLength(); ++j) {
                        Node message = listOfChildNodes.item(j);
                        if (!message.getNodeName().equalsIgnoreCase("message")) continue;
                        if (listOfMessages == null) {
                            listOfMessages = new ArrayList<UserMessage>();
                        }
                        listOfMessages.add(new UserMessage(message, level));
                    }
                }
            }
            if (listOfMessages == null) continue;
            messageMap.put(level, listOfMessages);
        }
        return messageMap;
    }

    public static SortedMap<UserMessageLevel, List<UserMessage>> getPlatformUserMessages(Node nodePlatform) throws Exception {
        TreeMap<UserMessageLevel, List<UserMessage>> messageMap = new TreeMap<UserMessageLevel, List<UserMessage>>();
        Node messageContainer = Utils.getChildNode(nodePlatform, "messages");
        if (messageContainer != null && messageContainer.hasChildNodes()) {
            for (UserMessageLevel level : UserMessageLevel.values()) {
                ArrayList<UserMessage> listOfMessages = null;
                String levelName = level.name().toLowerCase();
                NodeList listOfMessageByTypeContainers = messageContainer.getChildNodes();
                for (int i = 0; i < listOfMessageByTypeContainers.getLength(); ++i) {
                    Node messageByTypeContainer = listOfMessageByTypeContainers.item(i);
                    if (!messageByTypeContainer.getNodeName().equalsIgnoreCase(levelName)) continue;
                    NodeList listOfChildNodes = messageByTypeContainer.getChildNodes();
                    for (int j = 0; j < listOfChildNodes.getLength(); ++j) {
                        Node message = listOfChildNodes.item(j);
                        if (!message.getNodeName().equalsIgnoreCase("message")) continue;
                        if (listOfMessages == null) {
                            listOfMessages = new ArrayList<UserMessage>();
                        }
                        listOfMessages.add(new UserMessage(message, level));
                    }
                }
                if (listOfMessages == null) continue;
                messageMap.put(level, listOfMessages);
            }
        }
        return messageMap;
    }
}

