/*
 * Decompiled with CFR 0.152.
 */
package com.deepshiftlabs.nerrvana;

import com.deepshiftlabs.nerrvana.NerrvanaExecution;
import com.deepshiftlabs.nerrvana.NerrvanaPluginSettings;
import com.deepshiftlabs.nerrvana.Utils;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportActionAggregated
implements Action,
Serializable {
    private static final long serialVersionUID = 1L;
    private AbstractBuild<?, ?> build;
    private String executionResultsFilename;
    private Document results;
    private ArrayList<NerrvanaExecution> list;
    private String reportError;
    private NerrvanaPluginSettings settings;

    public ReportActionAggregated(AbstractBuild<?, ?> build, String executionResultsFilename, NerrvanaPluginSettings settings) {
        this.build = build;
        this.executionResultsFilename = executionResultsFilename;
        this.settings = settings;
        File buildDir = build.getRootDir();
        File executionResultsFile = new File(buildDir, executionResultsFilename);
        if (executionResultsFile.exists() && executionResultsFile.isFile()) {
            try {
                this.results = Utils.file2xml(executionResultsFile.getAbsolutePath());
                this.list = NerrvanaExecution.xml2list(this.results);
            }
            catch (Exception e) {
                this.reportError = e.getMessage();
            }
        } else {
            this.reportError = "Nerrvana execution results file '" + executionResultsFile.getAbsolutePath() + "' not found.";
        }
    }

    public String getExecutionResultsFilename() {
        return this.executionResultsFilename;
    }

    public String getIconFileName() {
        return "/plugin/NerrvanaPlugin/icons/nerrvana.png";
    }

    public String getDisplayName() {
        return "Nerrvana Report";
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.build;
    }

    public String getUrlName() {
        return "nerrvana";
    }

    public boolean hasError() {
        return this.reportError != null;
    }

    public String getErrorText() {
        return this.reportError;
    }

    public ArrayList<NerrvanaExecution> getList() {
        return this.list;
    }

    public String getExecutionStatus() {
        return NerrvanaExecution.testExecutionResults(this.build, this.settings) ? "SUCCESS" : "FAILURE";
    }

    public String getMessageThreshold() {
        return this.settings.messageThreshold.name();
    }
}

