/*
 * Decompiled with CFR 0.152.
 */
package com.deepshiftlabs.nerrvana;

import com.deepshiftlabs.nerrvana.HttpCommunicator;
import com.deepshiftlabs.nerrvana.Logger;
import com.deepshiftlabs.nerrvana.NerrvanaExecution;
import com.deepshiftlabs.nerrvana.NerrvanaPluginSettings;
import com.deepshiftlabs.nerrvana.ReportActionAggregated;
import com.deepshiftlabs.nerrvana.Testrun;
import com.deepshiftlabs.nerrvana.Utils;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NerrvanaPlugin
extends Builder {
    public final String settingsXmlString;
    public final String loglevel;
    private NerrvanaPluginSettings settings;
    private HttpCommunicator comm;
    private static final String ftpsTemplateWithLocalFolder = "open %s -u %s,%s\nset ftp:list-options -a\nset ftp:ssl-protect-data on\ncd %s\nlcd %s\nmirror --delete --parallel=50 -R .\n";
    private static final String ftpsTemplateNoFolder = "open %s -u %s,%s\nset ftp:list-options -a\nset ftp:ssl-protect-data on\ncd %s\nmirror --delete --parallel=50 -R .\nglob -a rm -r upload-build*\n";

    @DataBoundConstructor
    public NerrvanaPlugin(String settingsXmlString, String loglevel) {
        this.settingsXmlString = settingsXmlString;
        this.loglevel = loglevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        result = true;
        testrun = null;
        try {
            this.init(listener);
            testrun = this.startTestRun(build, launcher, listener);
            this.poll(build, testrun);
            this.saveExecutionResults(build, testrun);
        }
        catch (Exception e) {
            try {
                Logger.exception(e);
                result = false;
                this.saveExecutionResults(build, testrun);
            }
            catch (Throwable var7_9) {
                this.saveExecutionResults(build, testrun);
                if (this.settings.testExecutionResults) {
                    result = NerrvanaExecution.testExecutionResults(build, this.settings);
                    try {
                        this.saveReportAggregated(build, this.settings.executionResultsFilename);
                    }
                    catch (Exception e) {
                        Logger.exception(e);
                    }
                }
                throw var7_9;
            }
            if (this.settings.testExecutionResults) {
                result = NerrvanaExecution.testExecutionResults(build, this.settings);
                try {
                    this.saveReportAggregated(build, this.settings.executionResultsFilename);
                }
                catch (Exception e) {
                    Logger.exception(e);
                }
            } else {
                ** GOTO lbl42
            }
        }
        if (this.settings.testExecutionResults) {
            result = NerrvanaExecution.testExecutionResults(build, this.settings);
            try {
                this.saveReportAggregated(build, this.settings.executionResultsFilename);
            }
            catch (Exception e) {
                Logger.exception(e);
            }
        }
        Logger.infoln("\n-----END PLUGIN EXECUTION---\n\n");
        return result;
    }

    private Document getLastExecutionResult() {
        Document lastExecutionResult = null;
        ListIterator<Document> iterator = Utils.parsedDocuments.listIterator(Utils.parsedDocuments.size());
        while (iterator.hasPrevious()) {
            Document doc = iterator.previous();
            if (!doc.getDocumentElement().getNodeName().equals("executions")) continue;
            lastExecutionResult = doc;
            break;
        }
        return lastExecutionResult;
    }

    private void saveExecutionResultsImpl(AbstractBuild<?, ?> build, Document executionResults) throws Exception {
        Document allExecutionResults = null;
        File buildDir = build.getRootDir();
        File allExecutionResultsFile = new File(buildDir, this.settings.executionResultsFilename);
        Logger.infoln("Saving execution results into " + allExecutionResultsFile.getAbsolutePath() + "...");
        if (allExecutionResultsFile.exists()) {
            allExecutionResults = Utils.file2xml(allExecutionResultsFile.getAbsolutePath());
            NodeList list = executionResults.getDocumentElement().getElementsByTagName("execution");
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = allExecutionResults.adoptNode(list.item(i).cloneNode(true));
                allExecutionResults.getDocumentElement().appendChild(node);
            }
        } else {
            allExecutionResults = executionResults;
        }
        Utils.xml2file(allExecutionResults, allExecutionResultsFile);
        Logger.infoln("Done.");
    }

    private boolean saveExecutionResults(AbstractBuild<?, ?> build, Testrun testrun) {
        try {
            Document lastExecutionResult = this.getLastExecutionResult();
            if (lastExecutionResult != null) {
                NodeList nodelist = lastExecutionResult.getElementsByTagName("execution");
                if (testrun != null) {
                    Node exec = nodelist.item(0);
                    Utils.setChildNodeCDATAValue(exec, "testrun_name", testrun.name);
                    Utils.setChildNodeCDATAValue(exec, "testrun_description", testrun.description);
                } else {
                    Node exec = nodelist.item(0);
                    Utils.setChildNodeCDATAValue(exec, "testrun_name", this.settings.test_run_name);
                }
                this.saveExecutionResultsImpl(build, lastExecutionResult);
            } else {
                Logger.infoln("Plugin didn't create/start any test run. Nothing to save into execution results file.");
            }
            return true;
        }
        catch (Exception g) {
            Logger.exception(g);
            return false;
        }
    }

    private void saveReportAggregated(AbstractBuild<?, ?> build, String executionResultsFilename) throws Exception {
        build.getActions().add(new ReportActionAggregated(build, executionResultsFilename, this.settings));
    }

    private EnvVars getEnvironment(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        for (Map.Entry e : build.getBuildVariables().entrySet()) {
            envVars.put((String)e.getKey(), (String)e.getValue());
        }
        return envVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadTests(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws Exception {
        FilePath ws = build.getWorkspace();
        EnvVars envVars = this.getEnvironment(build, listener);
        String scriptContent = null;
        if (this.settings.folder_with_tests == null || this.settings.folder_with_tests.length() == 0) {
            scriptContent = String.format(ftpsTemplateNoFolder, this.settings.ftpsurl, this.settings.ftpsuser, this.settings.ftpspass, this.settings.space_path);
        } else if (ws.child(this.settings.folder_with_tests).exists()) {
            scriptContent = String.format(ftpsTemplateWithLocalFolder, this.settings.ftpsurl, this.settings.ftpsuser, this.settings.ftpspass, this.settings.space_path, this.settings.folder_with_tests);
        } else {
            Logger.infoln("Folder '" + this.settings.folder_with_tests + "' to pick tests from not found (Check configuration parameter 'Workspace folder')");
            return false;
        }
        StringBuilder sb = new StringBuilder("\n---BEGIN FTPS UPLOAD SCRIPT---\n").append(scriptContent).append("-----END FTPS UPLOAD SCRIPT---");
        Logger.traceln(sb.toString());
        FilePath script = ws.createTextTempFile("upload-build-" + build.getNumber() + "-", ".ftp", scriptContent, true);
        String[] cmd = new String[]{"lftp", "-f", script.getName()};
        try {
            boolean bl = launcher.launch().cmds(cmd).envs((Map)envVars).stdout((TaskListener)listener).pwd(ws).join() == 0;
            return bl;
        }
        finally {
            script.delete();
        }
    }

    private void init(BuildListener listener) throws Exception {
        Logger.init(listener.getLogger(), this.loglevel);
        Logger.infoln("\n\n---BEGIN PLUGIN EXECUTION---");
        Logger.infoln("---INITIALIZATION STARTED---");
        this.settings = NerrvanaPluginSettings.parse(Utils.string2xml(this.settingsXmlString));
        if (!this.settings.checkSettings()) {
            throw new Exception("Invalid plugin settings");
        }
        this.comm = new HttpCommunicator(this.settings);
        Logger.traceln("HttpCommunicator created");
        Logger.infoln("-----INITIALIZATION COMPLETED---\n");
    }

    private Testrun startTestRun(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws Exception {
        try {
            Testrun testrun = null;
            String tname = Testrun.assembleName(this.settings.test_run_name, build);
            Logger.infoln("Generated test run name: " + tname);
            String tdesc = Testrun.assembleDescription(build.getWorkspace(), this.settings);
            Logger.infoln("Generated test run description:\n" + tdesc + "\n");
            if (this.settings.skipUpload) {
                Logger.infoln("---TESTS UPLOAD SKIPPED---");
            } else {
                Logger.infoln("---BEGIN UPLOADING TESTS TO NERRVANA FTPS---");
                if (!this.uploadTests(build, launcher, listener)) {
                    Logger.infoln("---FTPS UPLOAD FAILED");
                    throw new Exception("Failed starting Nerrvana test run.");
                }
                Logger.infoln("-----END UPLOADING TESTS TO NERRVANA FTPS\n");
            }
            StringBuilder sb = new StringBuilder("Creating and starting test run via Nerrvana HTTP API call...");
            testrun = this.comm.createTestrun(this.settings.space_id, tname, tdesc, this.settings.platforms, this.settings.executable_file, false, this.settings.nodes_count);
            sb.append("done.");
            Logger.infoln(sb.toString());
            Logger.infoln("New test run ID#" + testrun.id + ".");
            Logger.infoln("New execution ID#" + testrun.exec_id + ".");
            return testrun;
        }
        catch (Exception e) {
            Document doc = NerrvanaExecution.fatalResult(this.getLastExecutionResult(), e, this.settings);
            Utils.cacheDocument(doc);
            throw e;
        }
    }

    private void poll(AbstractBuild<?, ?> build, Testrun testrun) throws Exception {
        NerrvanaExecution exec = new NerrvanaExecution();
        exec.id = testrun.exec_id;
        long lpoll = this.settings.getPollMillis();
        try {
            long lmaxtime;
            Logger.infoln("---BEGIN NERRVANA POLLING CYCLE (waiting for tests to complete)");
            for (lmaxtime = this.settings.getMaxtimeMillis(); lmaxtime > 0L; lmaxtime -= lpoll) {
                NerrvanaExecution newExec;
                Thread.sleep(lpoll);
                exec = newExec = this.comm.getExecutionStatus(exec.id);
                Logger.tori(exec.toString(), "\tCurrent execution status: " + exec.status + "\n");
                if (exec.status == null || exec.status.trim().length() == 0 || exec.status.indexOf("next") == 0 || exec.status.indexOf("run") == 0) continue;
                break;
            }
            Logger.infoln("-----END NERRVANA POLLING CYCLE---");
            if (lmaxtime <= 0L && exec.status.indexOf("run") == 0) {
                throw new Exception("Maximum Nervana test execution time exceeded (Consider increasing corresponding parameter in job config).\n");
            }
        }
        catch (Exception e) {
            Document doc = NerrvanaExecution.fatalResult(this.getLastExecutionResult(), e, this.settings);
            Utils.cacheDocument(doc);
            throw e;
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckSettingsXmlString(@QueryParameter String value) throws IOException, ServletException {
            try {
                NerrvanaPluginSettings.parse(Utils.string2xml(value));
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)"Cannot parse XML configuration");
            }
        }

        public FormValidation doCheckLoglevel(@QueryParameter String value) throws IOException, ServletException {
            if (value != null && (value.equals("normal") || value.equals("trace"))) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)("Unsupported log level: " + value));
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Nerrvana plug-in";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

