/*
 * Decompiled with CFR 0.152.
 */
package com.deepshiftlabs.nerrvana;

import com.deepshiftlabs.nerrvana.Logger;
import com.deepshiftlabs.nerrvana.NerrvanaPluginSettings;
import com.deepshiftlabs.nerrvana.Platform;
import com.deepshiftlabs.nerrvana.UserMessage;
import com.deepshiftlabs.nerrvana.UserMessageLevel;
import com.deepshiftlabs.nerrvana.Utils;
import hudson.model.AbstractBuild;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NerrvanaExecution {
    public String id;
    public String starttime;
    public String status;
    public String testrun_id;
    public String testrun_name;
    public String testrun_description;
    public ArrayList<Platform> platforms;

    public String getId() {
        return this.id;
    }

    public String getTestrunName() {
        return this.testrun_name;
    }

    public String getTestrunDescription() {
        return this.testrun_description;
    }

    public String getStarttime() {
        return this.starttime;
    }

    public String getStatus() {
        return this.status;
    }

    public ArrayList<Platform> getPlatforms() {
        return this.platforms;
    }

    public static boolean testExecutionResults(AbstractBuild<?, ?> build, NerrvanaPluginSettings settings) {
        try {
            File buildDir = build.getRootDir();
            File executionResultsFile = new File(buildDir, settings.executionResultsFilename);
            if (!executionResultsFile.exists() || !executionResultsFile.isFile()) {
                Logger.infoln("Test execution results file ['" + settings.executionResultsFilename + "'] not found - there is nothing to evaluate");
                return true;
            }
            Logger.infoln("---BEGIN TEST EXECUTION RESULTS---");
            boolean result = true;
            Document doc = Utils.file2xml(executionResultsFile.getAbsolutePath());
            NodeList platforms = doc.getElementsByTagName("platform");
            for (int i = 0; i < platforms.getLength(); ++i) {
                Node platform = platforms.item(i);
                String status = Utils.getUniqueChildNodeValue(platform, "status");
                if (status != null && status.equalsIgnoreCase("completed")) continue;
                String platformName = Utils.getUniqueChildNodeValue(platform, "name");
                result = false;
                Logger.infoln("Nerrvana execution on platform '" + platformName + "' failed with status '" + status + "'.");
                break;
            }
            if (result) {
                SortedMap<UserMessageLevel, List<UserMessage>> messageMap = UserMessage.getAllUserMessages(doc);
                for (Map.Entry<UserMessageLevel, List<UserMessage>> m : messageMap.entrySet()) {
                    UserMessageLevel key = m.getKey();
                    if (key.value() < settings.messageThreshold.value()) continue;
                    List<UserMessage> list = m.getValue();
                    Logger.infoln("At least " + list.size() + " message(s) from Nerrvana side reach(es) or exceed(s) threshold level (" + settings.messageThreshold.name() + ").\nMessage analyzer marks execution as failure.");
                    result = false;
                    break;
                }
            }
            if (result) {
                Logger.infoln("All Nerrvana executions successfully completed.");
            }
            Logger.infoln("-----END TEST EXECUTION RESULTS---");
            return result;
        }
        catch (Exception e) {
            Logger.exception(e);
            return false;
        }
    }

    public static Document fatalResult(Document lastExecutionResult, Exception e, NerrvanaPluginSettings settings) throws Exception {
        if (lastExecutionResult == null) {
            StringBuilder sb = new StringBuilder();
            Iterator<Platform> iterator = settings.platforms.iterator();
            while (iterator.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                Platform p = iterator.next();
                sb.append(p.name);
            }
            String platforms = sb.toString();
            sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?><executions>     <execution>         <id>N/A</id>         <testrun_id>N/A</testrun_id>         <testrun_name>Failed test run</testrun_name>         <testrun_description></testrun_description>         <start_datetime>N/A</start_datetime>         <status></status>         <platforms>             <platform>                 <id>N/A</id>                 <code>N/A</code>                 <name><![CDATA[").append(platforms).append("]]></name>                 <browse_url></browse_url>                 <status>N/A</status>                 <messages>                     <fatal>                         <message>                             <txt><![CDATA[").append(e.getMessage()).append("]]></txt>                             <created_time></created_time>                         </message>                     </fatal>                 </messages>             </platform>         </platforms>     </execution></executions>");
            lastExecutionResult = Utils.string2xml(sb.toString());
        } else {
            NodeList nodePlatforms = lastExecutionResult.getElementsByTagName("platform");
            for (int i = 0; i < nodePlatforms.getLength(); ++i) {
                Node platform = nodePlatforms.item(i);
                Node messages = Utils.createChildElementIfNotExists(platform, "messages");
                Node fatal = Utils.createChildElementIfNotExists(messages, "fatal");
                Node txt = Utils.createChildElementIfNotExists(fatal, "txt");
                Utils.setCDATAValue(txt, e.getMessage());
            }
        }
        return lastExecutionResult;
    }

    public static ArrayList<NerrvanaExecution> xml2list(Document doc) throws Exception {
        ArrayList<NerrvanaExecution> execs = new ArrayList<NerrvanaExecution>();
        NodeList nodeExecs = doc.getElementsByTagName("execution");
        for (int i = 0; i < nodeExecs.getLength(); ++i) {
            Node n = nodeExecs.item(i);
            execs.add(NerrvanaExecution.parseExecution(n));
        }
        return execs;
    }

    private static NerrvanaExecution parseExecution(Node parent) throws Exception {
        NodeList list = parent.getChildNodes();
        NerrvanaExecution exec = new NerrvanaExecution();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeName().equals("id")) {
                exec.id = Utils.nodeValue(n);
                continue;
            }
            if (n.getNodeName().equals("start_datetime")) {
                exec.starttime = Utils.nodeValue(n);
                continue;
            }
            if (n.getNodeName().equals("status")) {
                exec.status = Utils.nodeValue(n);
                continue;
            }
            if (n.getNodeName().equals("testrun_id")) {
                exec.testrun_id = Utils.nodeValue(n);
                continue;
            }
            if (n.getNodeName().equals("testrun_name")) {
                exec.testrun_name = Utils.nodeValue(n);
                continue;
            }
            if (n.getNodeName().equals("testrun_description")) {
                exec.testrun_description = Utils.nodeValue(n);
                continue;
            }
            if (!n.getNodeName().equals("platforms")) continue;
            exec.platforms = Platform.getPlatformList(n);
        }
        return exec;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("---BEGIN EXECUTION#").append(this.id).append("---\n").append("\tStart time: ").append(this.starttime).append("\n").append("\tStatus: ").append(this.status).append("\n");
        if (this.platforms != null) {
            for (int i = 0; i < this.platforms.size(); ++i) {
                sb.append(this.platforms.get(i).toString());
            }
        }
        sb.append("-----END EXECUTION#").append(this.id).append("---\n\n");
        return sb.toString();
    }
}

