/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration.supporting;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.neoload.integration.supporting.ServerInfo;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtilities
implements Serializable {
    private static final long serialVersionUID = -8773441162622083954L;
    private static final XPathFactory XPATHFACTORY = XPathFactory.newInstance();
    private static final XPath XPATH = XPATHFACTORY.newXPath();
    private static final Logger LOGGER = Logger.getLogger(XMLUtilities.class.getName());

    private XMLUtilities() {
        throw new IllegalAccessError();
    }

    public static String toXMLEscaped(Object obj) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj.getClass().getName()).append(";");
        sb.append(StringEscapeUtils.unescapeXml((String)new Gson().toJson(obj)));
        return sb.toString();
    }

    public static Object fromXMLEscaped(String xml) {
        ServerInfo si;
        String[] dataArray = xml.split(";", 2);
        String className = dataArray[0];
        String data = StringEscapeUtils.unescapeXml((String)dataArray[1]);
        Gson gson = new Gson();
        try {
            si = (ServerInfo)gson.fromJson(data, Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Issue converting stored data to a class instance. Type: " + className + ", data: " + xml, e);
            return null;
        }
        return si;
    }

    public static Node createNodeFromText(String xmlText) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xmlText));
        Document doc = db.parse(is);
        return doc.getFirstChild();
    }

    public static List<Node> findByExpression(String expression, Node searchNode) throws XPathExpressionException {
        XPathExpression expr = XPATH.compile(expression);
        NodeList nl = (NodeList)expr.evaluate(searchNode, XPathConstants.NODESET);
        return XMLUtilities.toList(nl);
    }

    public static Node findFirstByExpression(String expression, Node searchNode) throws XPathExpressionException {
        List<Node> results = XMLUtilities.findByExpression(expression, searchNode);
        if (results != null && results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public static Map<String, String> getMap(NamedNodeMap attributes) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.item(i) == null || attributes.item(i).getNodeName() == null) continue;
            map.put(attributes.item(i).getNodeName(), attributes.item(i).getNodeValue());
        }
        return map;
    }

    public static List<Node> toList(NodeList nodeList) {
        ArrayList<Node> list = new ArrayList<Node>(nodeList.getLength());
        for (int nlIndex = 0; nlIndex < nodeList.getLength(); ++nlIndex) {
            list.add(nodeList.item(nlIndex));
        }
        return list;
    }

    public static Document readXmlFile(String srcFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(srcFile);
        doc.getDocumentElement().normalize();
        return doc;
    }
}

