/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration.supporting;

import hudson.Extension;
import java.io.Serializable;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jenkinsci.plugins.neoload.integration.supporting.PluginUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.kohsuke.stapler.DataBoundConstructor;

public class ServerInfo
extends AbstractStepImpl
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(ServerInfo.class.getName());
    private static final long serialVersionUID = 460155244760235756L;
    private String uniqueID = "";
    private String url;
    private String loginUser;
    private String loginPassword;
    private String label;

    public ServerInfo() {
    }

    @DataBoundConstructor
    public ServerInfo(String uniqueID, String url, String loginUser, String loginPassword, String label) {
        this.uniqueID = uniqueID;
        this.url = url;
        this.loginUser = loginUser;
        this.loginPassword = loginPassword;
        this.label = label;
        if (StringUtils.trimToNull((String)this.uniqueID) == null) {
            this.uniqueID = this.getUniqueID();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(String loginUser) {
        this.loginUser = loginUser;
    }

    public String getLoginPassword() {
        try {
            String decoded = PluginUtils.decode(this.loginPassword);
            return decoded;
        }
        catch (DecoderException e) {
            LOGGER.log(Level.FINEST, "Issue decoding password for server. URL: " + this.url + ", user: " + this.loginUser + ", message: " + e.getMessage());
            return this.loginPassword;
        }
    }

    public void setLoginPassword(String loginPassword) {
        this.loginPassword = loginPassword;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUniqueID() {
        if (StringUtils.trimToEmpty((String)this.uniqueID).length() == 0) {
            Class<ServerInfo> clazz = ServerInfo.class;
            synchronized (ServerInfo.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return UUID.randomUUID().toString();
            }
        }
        return this.uniqueID;
    }

    public String getNonEmptyLabel(boolean forCollab) {
        if (this.getLabel().trim().isEmpty()) {
            return this.getUrl() + ", User: " + this.getLoginUser();
        }
        return this.getLabel();
    }

    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    public String getUniqueIDDoNotGenerate() {
        return this.uniqueID;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Extension
    public static class DescriptorImpl {
        public String getDisplayName() {
            return "ServerInfo";
        }
    }
}

