/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration.supporting;

public class NeoLoadReportDoc {
    public static final String AVG = "/@avg";
    public static final String VAL = "/@value";
    public static final String ERROR_RATE = "/@error_rate";
    public static final String PERCENTILE2 = "/@percentile2";
    public static final String PERCENTILE3 = "/@percentile3";
    private static final String VIRTUAL_USER_XML_PATH = "/report/virtual-users";
    private static final String MONITOR_XML_PATH = "/report/monitors/monitored-host[@name=\"";

    private NeoLoadReportDoc() {
    }

    public static String getXPathForCustomGraph(String litePath, String type) {
        String path = VIRTUAL_USER_XML_PATH;
        String[] tabSplited = litePath.startsWith("/") ? litePath.substring(1).split(">") : litePath.split(">");
        for (String str : tabSplited) {
            path = path + "/statistic-item[@name=\"" + str + "\"]";
        }
        return path + NeoLoadReportDoc.getTypeByStatistic(type);
    }

    public static String getXPathForCustomMonitorOrLGGraph(String litePath, String type) {
        String path = MONITOR_XML_PATH;
        if (litePath.startsWith("/")) {
            String splited = litePath.substring(1);
            int index = splited.indexOf(47);
            if (index < 0) {
                return null;
            }
            path = path + splited.substring(0, index);
        } else {
            int index = litePath.indexOf(47);
            if (index < 0) {
                return null;
            }
            path = path + litePath.substring(0, index);
        }
        path = path + "\"]/monitor/counters/statistic-item[@name=\"";
        path = path + litePath;
        path = path + "\"]";
        return path + NeoLoadReportDoc.getTypeByStatistic(type);
    }

    private static String getTypeByStatistic(String statistic) {
        String value;
        switch (statistic) {
            case "percentile": {
                value = PERCENTILE2;
                break;
            }
            case "average": {
                value = AVG;
                break;
            }
            case "error": {
                value = ERROR_RATE;
                break;
            }
            default: {
                value = VAL;
            }
        }
        return value;
    }
}

