/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration.steps;

import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.util.ListBoxModel;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.neoload.integration.steps.NeoloadRunStepExecution;
import org.jenkinsci.plugins.neoload.integration.supporting.GraphOptionsInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.NTSServerInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoloadGraphDefinitionStep;
import org.jenkinsci.plugins.neoload.integration.supporting.PipelineAsCodeEncodeDecode;
import org.jenkinsci.plugins.neoload.integration.supporting.PluginUtils;
import org.jenkinsci.plugins.neoload.integration.supporting.ServerInfo;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class NeoloadRunStep
extends AbstractStepImpl
implements NeoloadGraphDefinitionStep {
    public static final boolean DEFAULT_SHOW_TREND_AVERAGE_RESPONSE = false;
    public static final boolean DEFAULT_SHOW_TREND_ERROR_RATE = false;
    public static final String LICENSE_TYPE_LOCAL = "licenseTypeLocal";
    public static final String LICENSE_TYPE_SHARED = "licenseTypeShared";
    public static final String PROJECT_TYPE_LOCAL = "projectTypeLocal";
    public static final String PROJECT_TYPE_SHARED = "projectTypeShared";
    public static final String DEFAULT_HTML_REPORT = "neoload-report/report.html";
    public static final String DEFAULT_JUNIT_REPORT = "neoload-report/junit-sla-results.xml";
    public static final String DEFAULT_XML_REPORT = "neoload-report/report.xml";
    public static final String DEFAULT_TEST_NAME = "$Date{hh:mm - dd MMM yyyy} (build ${BUILD_NUMBER})";
    public static final String DEFAULT_TEST_DESCRIPTION = "";
    public static final String REPORT_TYPE_CUSTOM = "reportTypeCustom";
    public static final String REPORT_TYPE_DEFAULT = "reportTypeDefault";
    private String executable;
    private String projectType;
    private String reportType = "reportTypeDefault";
    private String localProjectFile;
    private ServerInfo sharedProjectServer;
    private String scenarioName;
    private String htmlReport = "neoload-report/report.html";
    private String xmlReport = "neoload-report/report.xml";
    private String pdfReport = "";
    private String junitReport = "neoload-report/junit-sla-results.xml";
    private boolean displayGUI;
    private String testResultName = "$Date{hh:mm - dd MMM yyyy} (build ${BUILD_NUMBER})";
    private String testDescription = "";
    private String customCommandLineOptions = "";
    private int maxTrends;
    private boolean showTrendAverageResponse = false;
    private boolean showTrendErrorRate = false;
    private List<GraphOptionsInfo> graphs;
    private String licenseType = "licenseTypeLocal";
    private NTSServerInfo licenseServer;
    private String sharedProjectName;
    private String licenseVUCount;
    private String licenseVUSAPCount;
    private String licenseDuration;
    private boolean publishTestResults;
    private boolean autoArchive = true;

    @DataBoundConstructor
    public NeoloadRunStep(String scenarioName) {
        this.scenarioName = scenarioName;
    }

    @DataBoundSetter
    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    @DataBoundSetter
    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getProjectType() {
        return this.projectType;
    }

    @DataBoundSetter
    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public String getReportType() {
        return this.reportType;
    }

    @DataBoundSetter
    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getLocalProjectFile() {
        return this.localProjectFile;
    }

    @DataBoundSetter
    public void setLocalProjectFile(String localProjectFile) {
        this.localProjectFile = localProjectFile;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public String getHtmlReport() {
        return this.htmlReport;
    }

    @DataBoundSetter
    public void setHtmlReport(String htmlReport) {
        this.htmlReport = htmlReport;
    }

    public String getXmlReport() {
        return this.xmlReport;
    }

    @DataBoundSetter
    public void setXmlReport(String xmlReport) {
        this.xmlReport = xmlReport;
    }

    public NTSServerInfo getLicenseServer() {
        return this.licenseServer;
    }

    @DataBoundSetter
    public void setLicenseServer(NTSServerInfo licenseServer) {
        this.licenseServer = licenseServer;
    }

    public String getPdfReport() {
        return this.pdfReport;
    }

    @DataBoundSetter
    public void setPdfReport(String pdfReport) {
        this.pdfReport = pdfReport;
    }

    public String getJunitReport() {
        return this.junitReport;
    }

    @DataBoundSetter
    public void setJunitReport(String junitReport) {
        this.junitReport = junitReport;
    }

    public boolean isDisplayGUI() {
        return this.displayGUI;
    }

    @DataBoundSetter
    public void setDisplayGUI(boolean displayGUI) {
        this.displayGUI = displayGUI;
    }

    public String getTestResultName() {
        return this.testResultName;
    }

    @DataBoundSetter
    public void setTestResultName(String testResultName) {
        this.testResultName = testResultName;
    }

    @CheckForNull
    public String getTestDescription() {
        return this.testDescription;
    }

    @DataBoundSetter
    public void setTestDescription(@CheckForNull String testDescription) {
        this.testDescription = Util.fixNull((String)testDescription);
    }

    public String getCustomCommandLineOptions() {
        return this.customCommandLineOptions;
    }

    @DataBoundSetter
    public void setCustomCommandLineOptions(String customCommandLineOptions) {
        this.customCommandLineOptions = customCommandLineOptions;
    }

    @Override
    public int getMaxTrends() {
        return this.maxTrends;
    }

    @Override
    @DataBoundSetter
    public void setMaxTrends(int maxTrends) {
        this.maxTrends = maxTrends;
    }

    @Override
    public boolean isShowTrendAverageResponse() {
        return this.showTrendAverageResponse;
    }

    @Override
    @DataBoundSetter
    public void setShowTrendAverageResponse(boolean showTrendAverageResponse) {
        this.showTrendAverageResponse = showTrendAverageResponse;
    }

    @Override
    public boolean isShowTrendErrorRate() {
        return this.showTrendErrorRate;
    }

    @Override
    @DataBoundSetter
    public void setShowTrendErrorRate(boolean showTrendErrorRate) {
        this.showTrendErrorRate = showTrendErrorRate;
    }

    @Override
    public List<GraphOptionsInfo> getGraphOptionsInfo() {
        return this.graphs;
    }

    @Override
    @DataBoundSetter
    public void setGraphOptionsInfo(List<GraphOptionsInfo> graphOptionsInfo) {
        this.graphs = graphOptionsInfo;
    }

    public ServerInfo getSharedProjectServer() {
        return this.sharedProjectServer;
    }

    @DataBoundSetter
    public void setSharedProjectServer(ServerInfo sharedProjectServer) {
        this.sharedProjectServer = sharedProjectServer;
    }

    public String getExecutable() {
        return this.executable;
    }

    @DataBoundSetter
    public void setScenarioName(String scenarioName) {
        this.scenarioName = scenarioName;
    }

    public String getSharedProjectName() {
        return this.sharedProjectName;
    }

    @DataBoundSetter
    public void setSharedProjectName(String sharedProjectName) {
        this.sharedProjectName = sharedProjectName;
    }

    public String getLicenseVUCount() {
        return this.licenseVUCount;
    }

    @DataBoundSetter
    public void setLicenseVUCount(String licenseVUCount) {
        this.licenseVUCount = licenseVUCount;
    }

    public String getLicenseVUSAPCount() {
        return this.licenseVUSAPCount;
    }

    @DataBoundSetter
    public void setLicenseVUSAPCount(String licenseVUSAPCount) {
        this.licenseVUSAPCount = licenseVUSAPCount;
    }

    public String getLicenseDuration() {
        return this.licenseDuration;
    }

    @DataBoundSetter
    public void setLicenseDuration(String licenseDuration) {
        this.licenseDuration = licenseDuration;
    }

    public boolean isPublishTestResults() {
        return this.publishTestResults;
    }

    @DataBoundSetter
    public void setPublishTestResults(boolean publishTestResults) {
        this.publishTestResults = publishTestResults;
    }

    public boolean isAutoArchive() {
        return this.autoArchive;
    }

    @DataBoundSetter
    public void setAutoArchive(boolean autoArchive) {
        this.autoArchive = autoArchive;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(NeoloadRunStepExecution.class);
        }

        public String getFunctionName() {
            return "neoloadRun";
        }

        @Nonnull
        public String getDisplayName() {
            return "Run a NeoLoad scenario";
        }

        public Map<String, Object> defineArguments(Step step) {
            return PipelineAsCodeEncodeDecode.encode((NeoloadRunStep)step);
        }

        public UninstantiatedDescribable uninstantiate(Step step) throws UnsupportedOperationException {
            return new UninstantiatedDescribable(this.defineArguments(step));
        }

        public Step newInstance(Map<String, Object> arguments) throws Exception {
            return PipelineAsCodeEncodeDecode.decode(arguments);
        }

        public static ListBoxModel doFillLicenseServerItems(@AncestorInPath Item project) {
            return PluginUtils.getServerInfosListBox(false);
        }

        public static ListBoxModel doFillSharedProjectServerItems(@AncestorInPath Item project) {
            return PluginUtils.getServerInfosListBox(true);
        }
    }
}

