/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration.steps;

import com.google.inject.Inject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.neoload.integration.ProjectSpecificAction;
import org.jenkinsci.plugins.neoload.integration.steps.NeoloadRefreshTrendStep;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoLoadPluginOptions;
import org.jenkinsci.plugins.neoload.integration.supporting.PluginUtils;
import org.jenkinsci.plugins.neoload.integration.supporting.SimpleBuildOption;
import org.jenkinsci.plugins.neoload.integration.supporting.SimpleBuildOptionBuilder;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class NeoloadRefreshTrendStepExecution
extends AbstractSynchronousNonBlockingStepExecution<Void> {
    @StepContextParameter
    private transient Run run;
    @StepContextParameter
    private transient TaskListener listener;
    @Inject
    private transient NeoloadRefreshTrendStep neoloadRefreshTrendStep;

    protected Void run() throws Exception {
        Job project = this.run.getParent();
        if (this.neoloadRefreshTrendStep.hasArguments()) {
            project.removeProperty(SimpleBuildOption.class);
            SimpleBuildOptionBuilder pluginOptions = this.getPluginOptionBuilder().setGraphOptionsInfos(this.neoloadRefreshTrendStep.getGraphOptionsInfo()).setMaxTrends(this.neoloadRefreshTrendStep.getMaxTrends()).setShowTrendAverageResponse(this.neoloadRefreshTrendStep.isShowTrendAverageResponse()).setShowTrendErrorRate(this.neoloadRefreshTrendStep.isShowTrendErrorRate());
            project.addProperty((JobProperty)pluginOptions.build());
        }
        this.listener.getLogger().println("Building trends...");
        PluginUtils.buildGraph(project);
        this.run.addAction((Action)new ProjectSpecificAction(this.run));
        return null;
    }

    private SimpleBuildOptionBuilder getPluginOptionBuilder() {
        NeoLoadPluginOptions pluginOptions = PluginUtils.getPluginOptions(this.run.getParent());
        return SimpleBuildOptionBuilder.fromNPO(pluginOptions);
    }
}

