/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.collections.CollectionUtils;
import org.jenkinsci.plugins.neoload.integration.supporting.CollabServerInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.NTSServerInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.PluginUtils;
import org.jenkinsci.plugins.neoload.integration.supporting.ServerInfo;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class NeoGlobalConfig
extends GlobalConfiguration
implements Serializable {
    private static final long serialVersionUID = -7914538879734307398L;
    private static final Logger LOGGER = Logger.getLogger(NeoGlobalConfig.class.getName());

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GlobalConfiguration> {
        private List<NTSServerInfo> ntsInfo = Collections.emptyList();
        private List<CollabServerInfo> collabInfo = Collections.emptyList();
        private String defaultExecutable = "";

        public DescriptorImpl() {
            super(NeoGlobalConfig.class);
            this.load();
        }

        public String getDisplayName() {
            return "NeoLoad Plugin Global Config";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            Object ntsInfoJson = json.get("ntsInfoName");
            List tempNTSInfo = req.bindJSONToList(NTSServerInfo.class, ntsInfoJson);
            Object collabInfoJson = json.get("collabInfoName");
            List tempCollabInfo = req.bindJSONToList(CollabServerInfo.class, collabInfoJson);
            Object defaultExecutableObject = json.get("defaultExecutable");
            this.defaultExecutable = defaultExecutableObject == null ? "" : defaultExecutableObject.toString();
            this.ntsInfo = tempNTSInfo == null ? Collections.emptyList() : tempNTSInfo;
            this.collabInfo = tempCollabInfo == null ? Collections.emptyList() : tempCollabInfo;
            Collection allServerInfo = CollectionUtils.union(this.ntsInfo, this.collabInfo);
            for (ServerInfo info : allServerInfo) {
                String plainTextPassword = info.getLoginPassword();
                try {
                    String encoded = PluginUtils.encode(plainTextPassword);
                    info.setLoginPassword(encoded);
                }
                catch (EncoderException e) {
                    LOGGER.log(Level.SEVERE, "Issue encoding password.", e);
                }
            }
            this.save();
            return true;
        }

        public List<NTSServerInfo> getNtsInfo() {
            return this.ntsInfo;
        }

        public void setNtsInfo(List<NTSServerInfo> ntsInfo) {
            this.ntsInfo = ntsInfo;
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            return PluginUtils.validateURL(url);
        }

        public FormValidation doCheckLoginUser(@QueryParameter String loginUser) {
            return PluginUtils.validateWarnIfEmpty(loginUser, "user");
        }

        public FormValidation doCheckLoginPassword(@QueryParameter String loginPassword) {
            return PluginUtils.validateWarnIfEmpty(loginPassword, "password");
        }

        public FormValidation doCheckPrivateKey(@QueryParameter String privateKey) {
            String[] extensions = new String[]{""};
            return PluginUtils.validateFileExists(privateKey, extensions, false, false);
        }

        public List<CollabServerInfo> getCollabInfo() {
            return this.collabInfo;
        }

        public void setCollabInfo(List<CollabServerInfo> collabInfo) {
            this.collabInfo = collabInfo;
        }

        public String getDefaultExecutable() {
            return this.defaultExecutable;
        }

        public void setDefaultExecutable(String defaultExecutable) {
            this.defaultExecutable = defaultExecutable;
        }
    }
}

