/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration;

import com.google.common.base.Joiner;
import com.neotys.nls.security.tools.PasswordEncoder;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.JobProperty;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BatchFile;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.tasks.CommandInterpreter;
import hudson.tasks.Shell;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jenkinsci.plugins.neoload.integration.NeoGlobalConfig;
import org.jenkinsci.plugins.neoload.integration.NeoResultsAction;
import org.jenkinsci.plugins.neoload.integration.NeoloadRunLauncher;
import org.jenkinsci.plugins.neoload.integration.ProjectSpecificAction;
import org.jenkinsci.plugins.neoload.integration.steps.NeoloadRunStep;
import org.jenkinsci.plugins.neoload.integration.supporting.CollabServerInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.GraphOptionsInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.NTSServerInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoLoadPluginOptions;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoloadException;
import org.jenkinsci.plugins.neoload.integration.supporting.PluginUtils;
import org.jenkinsci.plugins.neoload.integration.supporting.ServerInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.SimpleBuildOption;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class NeoBuildAction
extends CommandInterpreter
implements NeoLoadPluginOptions {
    private static final long serialVersionUID = 4651315889891892765L;
    private static final Logger LOGGER = Logger.getLogger(NeoBuildAction.class.getName());
    public static final String PROJECT_LOCAL = "local";
    public static final String PROJECT_SHARED = "shared";
    private final String executable;
    private final String projectType;
    private final String reportType;
    private final String localProjectFile;
    private final String sharedProjectName;
    private final String scenarioName;
    private final String htmlReport;
    private final String xmlReport;
    private final String pdfReport;
    private final String junitReport;
    private final boolean displayTheGUI;
    private final String testResultName;
    private final String testDescription;
    private final String licenseType;
    private final String licenseVUCount;
    private final String licenseVUSAPCount;
    private final String licenseDuration;
    private final String customCommandLineOptions;
    private final int maxTrends;
    private final boolean publishTestResults;
    private final boolean showTrendAverageResponse;
    private final boolean showTrendErrorRate;
    private final boolean scanAllBuilds;
    private final List<GraphOptionsInfo> graphOptionsInfo;
    private NTSServerInfo licenseServer;
    private ServerInfo sharedProjectServer;
    private CommandInterpreter commandInterpreter = null;
    private boolean archiveAndBuildTrends;

    @DataBoundConstructor
    public NeoBuildAction(String executable, String projectType, String reportType, String localProjectFile, String sharedProjectName, String scenarioName, String htmlReport, String xmlReport, String pdfReport, String junitReport, boolean scanAllBuilds, boolean displayTheGUI, String testResultName, String testDescription, String licenseType, String licenseVUCount, String licenseVUSAPCount, String licenseDuration, String customCommandLineOptions, boolean publishTestResults, ServerInfo sharedProjectServer, NTSServerInfo licenseServer, boolean showTrendAverageResponse, boolean showTrendErrorRate, List<GraphOptionsInfo> graphOptionsInfo, int maxTrends) {
        super(NeoBuildAction.class.getName() + " (command)");
        this.executable = executable;
        this.projectType = StringUtils.trimToEmpty((String)projectType);
        this.reportType = StringUtils.trimToEmpty((String)reportType);
        this.localProjectFile = localProjectFile;
        this.sharedProjectName = sharedProjectName;
        this.scenarioName = scenarioName;
        this.htmlReport = htmlReport;
        this.xmlReport = xmlReport;
        this.pdfReport = pdfReport;
        this.junitReport = junitReport;
        this.displayTheGUI = displayTheGUI;
        this.testResultName = testResultName;
        this.testDescription = testDescription;
        this.licenseType = StringUtils.trimToEmpty((String)licenseType);
        this.licenseVUCount = licenseVUCount;
        this.licenseVUSAPCount = licenseVUSAPCount;
        this.licenseDuration = licenseDuration;
        this.customCommandLineOptions = customCommandLineOptions;
        this.sharedProjectServer = this.updateUsingUniqueID(sharedProjectServer);
        this.publishTestResults = publishTestResults;
        this.licenseServer = this.updateUsingUniqueID(licenseServer);
        this.showTrendAverageResponse = showTrendAverageResponse;
        this.showTrendErrorRate = showTrendErrorRate;
        this.graphOptionsInfo = graphOptionsInfo;
        this.maxTrends = maxTrends;
        this.scanAllBuilds = scanAllBuilds;
    }

    public NeoBuildAction(NeoloadRunStep step) {
        this(step.getExecutable(), step.getProjectType(), step.getReportType(), step.getLocalProjectFile(), step.getSharedProjectName(), step.getScenarioName(), step.getHtmlReport(), step.getXmlReport(), step.getPdfReport(), step.getJunitReport(), false, step.isDisplayGUI(), step.getTestResultName(), step.getTestDescription(), step.getLicenseType(), step.getLicenseVUCount(), step.getLicenseVUSAPCount(), step.getLicenseDuration(), step.getCustomCommandLineOptions(), step.isPublishTestResults(), step.getSharedProjectServer(), step.getLicenseServer(), step.isShowTrendAverageResponse(), step.isShowTrendErrorRate(), step.getGraphOptionsInfo(), step.getMaxTrends());
        this.setArchiveAndBuildTrends(step.isAutoArchive());
    }

    public static boolean isOsWindows(Launcher launcher) {
        return !launcher.isUnix();
    }

    private static void addNTSArguments(List<String> commands, NTSServerInfo n, Map<String, String> hashedPasswords) {
        commands.add("-NTS \"" + n.getUrl() + "\"");
        commands.add("-NTSLogin \"" + n.getLoginUser() + ":" + hashedPasswords.get(n.getLoginPassword()) + "\"");
    }

    <T extends ServerInfo> T updateUsingUniqueID(T serverInfo) {
        if (serverInfo == null || StringUtils.trimToNull((String)serverInfo.getUniqueID()) == null) {
            return serverInfo;
        }
        if (Jenkins.getInstance() == null) {
            return serverInfo;
        }
        NeoGlobalConfig.DescriptorImpl globalConfigDescriptor = PluginUtils.getNeoGlobalConfig();
        if (globalConfigDescriptor == null) {
            return serverInfo;
        }
        Collection allServerInfo = CollectionUtils.union(globalConfigDescriptor.getNtsInfo(), globalConfigDescriptor.getCollabInfo());
        for (ServerInfo si : allServerInfo) {
            if (!si.getUniqueID().equals(serverInfo.getUniqueID())) continue;
            return (T)si;
        }
        return serverInfo;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        StringBuilder sb = this.prepareCommandLine(launcher, null);
        build.addAction((Action)new NeoResultsAction(build, this.getXMLReportArtifactPath(), this.getHTMLReportArtifactPath()));
        return this.runTheCommand(sb.toString(), build, launcher, listener);
    }

    protected StringBuilder prepareCommandLine(Launcher launcher, FilePath currentWorkspace) {
        this.sharedProjectServer = this.updateUsingUniqueID(this.sharedProjectServer);
        this.licenseServer = this.updateUsingUniqueID(this.licenseServer);
        Map<String, String> hashedPasswords = this.getHashedPasswords();
        String executable = this.getExecutable();
        if (Files.isDirectory(Paths.get(executable, new String[0]), new LinkOption[0]) || !Files.exists(Paths.get(executable, new String[0]), new LinkOption[0])) {
            LOGGER.log(Level.WARNING, "Can't find NeoLoad executable: " + executable);
        }
        ArrayList<String> commands = new ArrayList<String>();
        this.setupProjectType(commands, hashedPasswords);
        this.setupTestInfo(commands, launcher);
        this.setupLicenseInfo(commands, hashedPasswords);
        this.setupReports(commands, launcher, currentWorkspace);
        if (!this.displayTheGUI) {
            commands.add("-noGUI");
        } else {
            commands.add("-exit");
        }
        commands.add(this.customCommandLineOptions);
        ArrayList<String> cleanedCommands = new ArrayList<String>(new LinkedHashSet<String>(commands));
        StringBuilder sb = new StringBuilder();
        sb.append("\"" + executable + "\"");
        for (String command : cleanedCommands) {
            sb.append(" " + command.replaceAll("\\r||\\n", ""));
        }
        return sb;
    }

    Map<String, String> getHashedPasswords() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.sharedProjectServer != null && StringUtils.trimToNull((String)this.sharedProjectServer.getLoginPassword()) != null) {
            map.put(this.sharedProjectServer.getLoginPassword(), "## use the password-scrambler to resolve this issue ##");
        }
        if (this.licenseServer != null && StringUtils.trimToNull((String)this.licenseServer.getLoginPassword()) != null) {
            map.put(this.licenseServer.getLoginPassword(), "## use the password-scrambler to resolve this issue ##");
        }
        if (map.size() == 0) {
            LOGGER.finest("No passwords to scramble.");
            return map;
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                resultMap.put(entry.getKey(), PasswordEncoder.encode((String)entry.getKey()));
            }
        }
        catch (UnsupportedEncodingException | GeneralSecurityException e) {
            LOGGER.log(Level.SEVERE, "Exception during password encryption", e);
            throw new RuntimeException(e);
        }
        return resultMap;
    }

    private void setupReports(List<String> commands, Launcher launcher, FilePath currentWorkspace) {
        String workspaceVariable = currentWorkspace == null ? (NeoBuildAction.isOsWindows(launcher) ? "%WORKSPACE%" : "${WORKSPACE}") : currentWorkspace.getRemote();
        if (this.isRepportCustomPath()) {
            List<String> reportPaths = PluginUtils.removeAllEmpties(this.htmlReport, this.xmlReport, this.pdfReport);
            String reportFileNames = Joiner.on((String)",").skipNulls().join(reportPaths);
            if (StringUtils.trimToEmpty((String)reportFileNames).length() > 0) {
                commands.add("-report \"" + reportFileNames + "\"");
            }
            if (StringUtils.trimToEmpty((String)this.junitReport).length() > 0) {
                commands.add("-SLAJUnitResults \"" + this.junitReport + "\"");
            }
        } else {
            commands.add("-report \"" + workspaceVariable + "/neoload-report/report.html," + workspaceVariable + "/neoload-report/report.xml\"");
            commands.add("-SLAJUnitResults \"" + workspaceVariable + "/neoload-report/junit-sla-results.xml\"");
        }
    }

    private String computeVuCount() {
        if (PluginUtils.isSAP(this.licenseVUSAPCount)) {
            return this.licenseVUCount + ";" + this.licenseVUSAPCount;
        }
        return this.licenseVUCount;
    }

    public String getLicenseVUSAPCount() {
        return this.licenseVUSAPCount;
    }

    private void setupLicenseInfo(List<String> commands, Map<String, String> hashedPasswords) {
        if (!this.licenseType.toLowerCase().contains(PROJECT_LOCAL)) {
            if (this.licenseType.toLowerCase().contains(PROJECT_SHARED)) {
                NeoBuildAction.addNTSArguments(commands, this.licenseServer, hashedPasswords);
                commands.add("-leaseLicense \"" + this.licenseServer.getLicenseID() + ":" + this.computeVuCount() + ":" + this.licenseDuration + "\"");
            } else {
                throw new RuntimeException("Unrecognized license type \"" + this.licenseType + "\" (expected local or shared).");
            }
        }
    }

    private void setupTestInfo(List<String> commands, Launcher launcher) {
        commands.add("-launch \"" + this.scenarioName + "\"");
        String escapedTestResultName = NeoBuildAction.isOsWindows(launcher) ? this.testResultName : this.testResultName.replaceAll(Pattern.quote("$Date{") + "(.*?)" + Pattern.quote("}"), Matcher.quoteReplacement("\\$Date{") + "$1" + Matcher.quoteReplacement("}"));
        if (StringUtils.trimToNull((String)escapedTestResultName) != null) {
            commands.add("-testResultName \"" + escapedTestResultName + "\"");
        }
        if (StringUtils.trimToNull((String)this.testDescription) != null) {
            commands.add("-description \"" + this.testDescription + "\"");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupProjectType(List<String> commands, Map<String, String> hashedPasswords) {
        if (this.projectType.toLowerCase().contains(PROJECT_LOCAL)) {
            commands.add("-project \"" + this.localProjectFile + "\"");
        } else {
            if (!this.projectType.toLowerCase().contains(PROJECT_SHARED)) throw new RuntimeException("Unrecognized project type \"" + this.projectType + "\" (expected local or shared).");
            commands.add("-checkoutProject \"" + this.sharedProjectName + "\"");
            if (this.sharedProjectServer instanceof NTSServerInfo) {
                NeoBuildAction.addNTSArguments(commands, (NTSServerInfo)this.sharedProjectServer, hashedPasswords);
                commands.add("-NTSCollabPath \"" + ((NTSServerInfo)this.sharedProjectServer).getCollabPath() + "\"");
            } else {
                if (!(this.sharedProjectServer instanceof CollabServerInfo)) throw new RuntimeException("Unrecognized ServerInfo type: " + this.sharedProjectServer.getClass().getName());
                CollabServerInfo csi = (CollabServerInfo)this.sharedProjectServer;
                commands.add("-Collab \"" + csi.getUrl() + "\"");
                StringBuilder sb = this.setupCollabLogin(hashedPasswords, csi);
                commands.add(sb.toString());
            }
        }
        if (!this.publishTestResults) return;
        commands.add("-publishTestResult");
    }

    StringBuilder setupCollabLogin(Map<String, String> hashedPasswords, CollabServerInfo csi) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.trimToNull((String)csi.getLoginUser()) != null) {
            sb.append(csi.getLoginUser());
        }
        if (StringUtils.trimToNull((String)hashedPasswords.get(csi.getLoginPassword())) != null) {
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(hashedPasswords.get(csi.getLoginPassword()));
        }
        if (StringUtils.trimToNull((String)csi.getPrivateKey()) != null) {
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(csi.getPrivateKey());
        }
        if (StringUtils.trimToNull((String)csi.getPassphrase()) != null) {
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(csi.getPassphrase());
        }
        sb.insert(0, "-CollabLogin ");
        return sb;
    }

    private boolean runTheCommand(String command, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        this.commandInterpreter = NeoBuildAction.isOsWindows(launcher) ? new BatchFile(command) : new Shell(command);
        LOGGER.log(Level.FINEST, "Executing command: " + command);
        return this.commandInterpreter.perform(build, launcher, listener);
    }

    public String isProjectType(String type) {
        if (StringUtils.trimToNull((String)this.projectType) == null) {
            return "projectTypeLocal".equalsIgnoreCase(type) ? "true" : "false";
        }
        return this.projectType.equalsIgnoreCase(type) ? "true" : "false";
    }

    public boolean isReportType(String type) {
        if (StringUtils.trimToNull((String)this.reportType) == null) {
            return "reportTypeDefault".equalsIgnoreCase(type);
        }
        return this.reportType.equalsIgnoreCase(type);
    }

    public boolean isRepportCustomPath() {
        return this.isReportType("reportTypeCustom");
    }

    public String isLicenseType(String type) {
        if (StringUtils.trimToNull((String)this.licenseType) == null) {
            return "licenseTypeLocal".equalsIgnoreCase(type) ? "true" : "false";
        }
        return this.licenseType.equalsIgnoreCase(type) ? "true" : "false";
    }

    public String getXMLReportArtifactPath() {
        return this.constructXMLReportArtifactPath();
    }

    public String constructXMLReportArtifactPath() {
        if (this.isRepportCustomPath()) {
            return PluginUtils.removeWorkspaceOrRelativePoint(this.xmlReport);
        }
        return "/neoload-report/report.xml";
    }

    public String getHTMLReportArtifactPath() {
        return this.constructHTMLReportArtifactPath();
    }

    public String constructHTMLReportArtifactPath() {
        if (this.isRepportCustomPath()) {
            return PluginUtils.removeWorkspaceOrRelativePoint(this.htmlReport);
        }
        return "/neoload-report/report.html";
    }

    public Descriptor<Builder> getDescriptor() {
        DescriptorImpl descriptor = (DescriptorImpl)super.getDescriptor();
        descriptor.setNeoBuildAction(this);
        return descriptor;
    }

    public String[] buildCommandLine(FilePath script) {
        return this.commandInterpreter.buildCommandLine(script);
    }

    protected String getContents() {
        if (SystemUtils.IS_OS_WINDOWS) {
            new BatchFileMine().getContents();
        }
        return new ShellMine().getContents();
    }

    protected String getFileExtension() {
        if (SystemUtils.IS_OS_WINDOWS) {
            new BatchFileMine().getFileExtension();
        }
        return new ShellMine().getFileExtension();
    }

    public String getExecutable() {
        if (StringUtils.isEmpty((String)this.executable)) {
            return PluginUtils.getNeoGlobalConfig().getDefaultExecutable();
        }
        return this.executable;
    }

    public String getSharedProjectName() {
        return this.sharedProjectName;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public String getHtmlReport() {
        return this.htmlReport;
    }

    public String getXmlReport() {
        return this.xmlReport;
    }

    public String getPdfReport() {
        return this.pdfReport;
    }

    public String getJunitReport() {
        return this.junitReport;
    }

    public boolean isDisplayTheGUI() {
        return this.displayTheGUI;
    }

    public String getTestResultName() {
        return this.testResultName;
    }

    public String getTestDescription() {
        return this.testDescription;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public String getLicenseVUCount() {
        return this.licenseVUCount;
    }

    public String getLicenseDuration() {
        return this.licenseDuration;
    }

    public String getCustomCommandLineOptions() {
        return this.customCommandLineOptions;
    }

    public String getLocalProjectFile() {
        return this.localProjectFile;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public String getReportType() {
        return this.reportType;
    }

    public boolean getPublishTestResults() {
        return this.publishTestResults;
    }

    public ServerInfo getLicenseServer() {
        return this.licenseServer;
    }

    public void setLicenseServer(NTSServerInfo licenseServer) {
        this.licenseServer = licenseServer;
    }

    public ServerInfo getSharedProjectServer() {
        return this.sharedProjectServer;
    }

    public void setSharedProjectServer(ServerInfo sharedProjectServer) {
        this.sharedProjectServer = sharedProjectServer;
    }

    @Override
    public boolean isScanAllBuilds() {
        return this.scanAllBuilds;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public boolean isShowTrendAverageResponse() {
        return this.showTrendAverageResponse;
    }

    @Override
    public boolean isShowTrendErrorRate() {
        return this.showTrendErrorRate;
    }

    @Override
    public List<GraphOptionsInfo> getGraphOptionsInfo() {
        return this.graphOptionsInfo;
    }

    @Override
    public int getMaxTrends() {
        return this.maxTrends;
    }

    public void perform(Run<?, ?> run, FilePath ws, Launcher launcher, TaskListener listener) throws Exception {
        StringBuilder sb = this.prepareCommandLine(launcher, ws);
        SimpleBuildOption jobProp = SimpleBuildOption.fromNPO(this);
        run.getParent().removeProperty(SimpleBuildOption.class);
        run.getParent().addProperty((JobProperty)jobProp);
        run.addAction((Action)new NeoResultsAction(run, this.xmlReport, this.htmlReport));
        boolean returnedValue = new NeoloadRunLauncher(sb.toString(), launcher).perform(run, ws, launcher, listener);
        run.addAction((Action)new ProjectSpecificAction(run));
        if (this.isArchiveAndBuildTrends()) {
            String artifact = PluginUtils.forgeArtifactoryPath(this);
            listener.getLogger().println("Archiving " + artifact);
            ArtifactArchiver archiver = new ArtifactArchiver(artifact);
            archiver.perform(run, ws, launcher, listener);
            listener.getLogger().println("Building trends...");
            PluginUtils.buildGraph(run.getParent());
        }
        if (!returnedValue) {
            throw new NeoloadException("Error occurred during the test.");
        }
    }

    public boolean isArchiveAndBuildTrends() {
        return this.archiveAndBuildTrends;
    }

    public void setArchiveAndBuildTrends(boolean archiveAndBuildTrends) {
        this.archiveAndBuildTrends = archiveAndBuildTrends;
    }

    public class ShellMine
    extends Shell {
        public ShellMine() {
            super("command");
        }

        public String getContents() {
            return super.getContents();
        }

        public String getFileExtension() {
            return super.getFileExtension();
        }
    }

    private class BatchFileMine
    extends BatchFile {
        public BatchFileMine() {
            super("command");
        }

        public String getContents() {
            return super.getContents();
        }

        public String getFileExtension() {
            return super.getFileExtension();
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private NeoBuildAction neoBuildAction = null;

        public DescriptorImpl() {
            super(NeoBuildAction.class);
            this.load();
        }

        public static ListBoxModel getLicenseServerOptions(ServerInfo preselected) {
            NeoGlobalConfig.DescriptorImpl globalConfigDescriptor = PluginUtils.getNeoGlobalConfig();
            ListBoxModel listBoxModel = new ListBoxModel();
            if (globalConfigDescriptor == null) {
                LOGGER.log(Level.FINEST, "No NeoLoad server settings found. Please add servers before configuring jobs. (getLicenseServerOptions)");
            } else {
                for (NTSServerInfo server : globalConfigDescriptor.getNtsInfo()) {
                    String displayName = DescriptorImpl.buildNTSDisplayNameString(server, false);
                    String optionValue = server.getUniqueID();
                    ListBoxModel.Option option = new ListBoxModel.Option(displayName, optionValue);
                    if (server.equals(preselected)) {
                        option.selected = true;
                    }
                    listBoxModel.add((Object)option);
                }
            }
            if (listBoxModel.isEmpty()) {
                LOGGER.finest("There is no NTS Server configured !");
                listBoxModel.add((Object)new ListBoxModel.Option("Please configure Jenkins System Settings for NeoLoad to add an NTS server.", null));
            }
            return listBoxModel;
        }

        public static String buildNTSDisplayNameString(NTSServerInfo server, boolean isSharedProjectDisplay) {
            if (StringUtils.trimToEmpty((String)server.getLabel()).length() > 0) {
                return server.getLabel();
            }
            StringBuilder displayName = new StringBuilder(server.getUrl());
            if (isSharedProjectDisplay) {
                displayName.append(", Repository: " + server.getCollabPath());
            } else if (StringUtils.trimToNull((String)server.getLicenseID()) != null) {
                displayName.append(", LicenseID: " + StringUtils.left((String)server.getLicenseID(), (int)4) + "..." + StringUtils.right((String)server.getLicenseID(), (int)4));
                displayName.append(" (NTS)");
            }
            return displayName.toString();
        }

        public void setNeoBuildAction(NeoBuildAction action) {
            this.neoBuildAction = action;
        }

        public String getDisplayName() {
            return "Execute a NeoLoad Scenario";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return super.configure(req, json);
        }

        public ListBoxModel doFillSharedProjectServerItems(@AncestorInPath Item project) {
            ServerInfo preselected = null;
            if (this.neoBuildAction != null && this.neoBuildAction.sharedProjectServer != null) {
                preselected = this.neoBuildAction.sharedProjectServer;
            }
            return this.getProjectServerOptions(preselected);
        }

        public ListBoxModel doFillLicenseServerItems(@AncestorInPath Item project) {
            NTSServerInfo preselected = null;
            if (this.neoBuildAction != null && this.neoBuildAction.licenseServer != null) {
                preselected = this.neoBuildAction.licenseServer;
            }
            return DescriptorImpl.getLicenseServerOptions(preselected);
        }

        private ListBoxModel getProjectServerOptions(ServerInfo preselected) {
            ListBoxModel.Option option;
            String optionValue;
            String displayName;
            NeoGlobalConfig.DescriptorImpl globalConfigDescriptor = PluginUtils.getNeoGlobalConfig();
            ListBoxModel listBoxModel = new ListBoxModel();
            if (globalConfigDescriptor == null) {
                LOGGER.log(Level.FINEST, "No NeoLoad server settings found. Please add servers before configuring jobs. (getProjectServerOptions)");
            } else {
                for (NTSServerInfo nTSServerInfo : globalConfigDescriptor.getNtsInfo()) {
                    displayName = DescriptorImpl.buildNTSDisplayNameString(nTSServerInfo, true);
                    optionValue = nTSServerInfo.getUniqueID();
                    option = new ListBoxModel.Option(displayName, optionValue);
                    if (nTSServerInfo.equals(preselected)) {
                        option.selected = true;
                    }
                    listBoxModel.add((Object)option);
                }
            }
            for (CollabServerInfo collabServerInfo : globalConfigDescriptor.getCollabInfo()) {
                displayName = collabServerInfo.getNonEmptyLabel(true);
                optionValue = collabServerInfo.getUniqueID();
                option = new ListBoxModel.Option(displayName, optionValue);
                if (collabServerInfo.equals(preselected)) {
                    option.selected = true;
                }
                listBoxModel.add((Object)option);
            }
            if (listBoxModel.isEmpty()) {
                LOGGER.finest("There is no Server configured !");
                listBoxModel.add((Object)new ListBoxModel.Option("Please configure Jenkins System Settings for NeoLoad to add a server.", null));
            }
            return listBoxModel;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckLocalProjectFile(@QueryParameter(value="localProjectFile") String localProjectFile) {
            String[] extensions = new String[]{".nlp", ".yaml", ".yml", ".json"};
            return PluginUtils.validateFileExists(localProjectFile, extensions, true, false);
        }

        public FormValidation doCheckExecutable(@QueryParameter String executable) {
            String[] extensions = new String[]{".exe"};
            return PluginUtils.validateFileExists(executable, extensions, false, true);
        }

        public FormValidation doCheckLicenseVUCount(@QueryParameter String licenseVUCount) {
            return PluginUtils.formValidationErrorToWarning(FormValidation.validatePositiveInteger((String)licenseVUCount));
        }

        public FormValidation doCheckLicenseDuration(@QueryParameter String licenseDuration) {
            return PluginUtils.formValidationErrorToWarning(FormValidation.validatePositiveInteger((String)licenseDuration));
        }

        public FormValidation doCheckLicenseID(@QueryParameter String licenseID) {
            return PluginUtils.formValidationErrorToWarning(FormValidation.validateRequired((String)licenseID));
        }

        public FormValidation doCheckSharedProjectName(@QueryParameter String sharedProjectName) {
            return PluginUtils.formValidationErrorToWarning(FormValidation.validateRequired((String)sharedProjectName));
        }

        public FormValidation doCheckXmlReport(@QueryParameter String xmlReport) {
            return PluginUtils.formValidationErrorToWarning(FormValidation.validateRequired((String)xmlReport));
        }

        public FormValidation doCheckScenarioName(@QueryParameter String scenarioName) {
            return PluginUtils.formValidationErrorToWarning(FormValidation.validateRequired((String)scenarioName));
        }

        public FormValidation doCheckDisplayTheGUI(@QueryParameter String displayTheGUI) {
            if (Boolean.valueOf(displayTheGUI).booleanValue()) {
                return FormValidation.warning((String)"The user launching the process must be able to display a user interface (which is not always the case for the Jenkins user). Some errors or warning messages may prevent NeoLoad from closing automatically at the end of a test run. Thus this should only be used for testing purposes.");
            }
            return FormValidation.ok();
        }
    }
}

