/*
 * Decompiled with CFR 0.152.
 */
package com.chikli.hudson.plugin.naginator;

import com.chikli.hudson.plugin.naginator.NaginatorAction;
import com.chikli.hudson.plugin.naginator.NaginatorCause;
import com.chikli.hudson.plugin.naginator.NaginatorListener;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.ParametersAction;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerResponse;

public class NaginatorRetryAction
implements Action {
    private boolean hasPermission() {
        Run run = (Run)Stapler.getCurrentRequest().findAncestorObject(Run.class);
        if (run == null) {
            return false;
        }
        if (!(run instanceof AbstractBuild)) {
            return false;
        }
        return run.getParent().hasPermission(Item.BUILD);
    }

    public String getIconFileName() {
        return this.hasPermission() ? "refresh.png" : null;
    }

    public String getDisplayName() {
        return this.hasPermission() ? "Retry" : null;
    }

    public String getUrlName() {
        return this.hasPermission() ? "retry" : null;
    }

    public void doIndex(StaplerResponse res, @CheckForNull @AncestorInPath AbstractBuild<?, ?> build) throws IOException {
        if (build == null) {
            res.sendError(404);
            return;
        }
        ((AbstractProject)build.getParent()).checkPermission(Item.BUILD);
        NaginatorRetryAction.scheduleBuild(build, 0, NaginatorListener.calculateRetryCount(build), 0);
        res.sendRedirect2(build.getUpUrl());
    }

    static boolean scheduleBuild(AbstractBuild<?, ?> build, int delay, int retryCount, int maxRetryCount) {
        return NaginatorRetryAction.scheduleBuild(build, delay, new NaginatorAction((Run<?, ?>)build, retryCount, maxRetryCount));
    }

    static boolean scheduleBuild(AbstractBuild<?, ?> build, int delay, NaginatorAction action) {
        ArrayList<NaginatorAction> actions = new ArrayList<NaginatorAction>();
        actions.add(action);
        actions.add((NaginatorAction)build.getAction(ParametersAction.class));
        actions.add((NaginatorAction)build.getAction(CauseAction.class));
        return build.getProject().scheduleBuild(delay, (Cause)new NaginatorCause(build), actions.toArray(new Action[actions.size()]));
    }
}

