/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.multiplescms;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.NullSCM;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.DescribableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.multiplescms.MultiSCMChangeLogParser;
import org.jenkinsci.plugins.multiplescms.MultiSCMRepositoryBrowser;
import org.jenkinsci.plugins.multiplescms.MultiSCMRevisionState;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class MultiSCM
extends SCM
implements Saveable {
    private DescribableList<SCM, Descriptor<SCM>> scms = new DescribableList((Saveable)this);

    @DataBoundConstructor
    public MultiSCM(List<SCM> scmList) throws IOException {
        this.scms.addAll(scmList);
    }

    @Exported
    public List<SCM> getConfiguredSCMs() {
        return this.scms.toList();
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        MultiSCMRevisionState revisionStates = new MultiSCMRevisionState();
        for (SCM scm : this.scms) {
            SCMRevisionState scmState = scm.calcRevisionsFromBuild(build, launcher, listener);
            revisionStates.add(scm, build.getWorkspace(), (Run<?, ?>)build, scmState);
        }
        return revisionStates;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        for (int i = 0; i < this.scms.size(); ++i) {
            try {
                EnvVars currScmVars = new EnvVars();
                ((SCM)this.scms.get(i)).buildEnvVars(build, (Map)currScmVars);
                for (Map.Entry entry : currScmVars.entrySet()) {
                    if (env.containsKey(entry.getKey())) {
                        env.put((String)entry.getKey() + "_" + i, (String)entry.getValue());
                        continue;
                    }
                    env.put((String)entry.getKey(), (String)entry.getValue());
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        MultiSCMRevisionState baselineStates = baseline instanceof MultiSCMRevisionState ? (MultiSCMRevisionState)baseline : null;
        MultiSCMRevisionState currentStates = new MultiSCMRevisionState();
        PollingResult.Change overallChange = PollingResult.Change.NONE;
        for (SCM scm : this.scms) {
            SCMRevisionState scmBaseline;
            SCMRevisionState sCMRevisionState = scmBaseline = baselineStates != null ? baselineStates.get(scm, workspace, null) : null;
            if (scmBaseline instanceof MultiSCMRevisionState && !(scm instanceof MultiSCM)) continue;
            PollingResult scmResult = scm.poll(project, launcher, workspace, listener, scmBaseline != null ? scmBaseline : SCMRevisionState.NONE);
            currentStates.add(scm, workspace, null, scmResult.remote);
            if (scmResult.change.compareTo((Enum)overallChange) <= 0) continue;
            overallChange = scmResult.change;
        }
        return new PollingResult((SCMRevisionState)baselineStates, (SCMRevisionState)currentStates, overallChange);
    }

    public void checkout(Run<?, ?> build, Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        MultiSCMRevisionState oldBaseline = baseline instanceof MultiSCMRevisionState ? (MultiSCMRevisionState)baseline : null;
        MultiSCMRevisionState revisionState = new MultiSCMRevisionState();
        build.addAction((Action)revisionState);
        HashSet<Action> scmActions = new HashSet<Action>();
        FileOutputStream logStream = new FileOutputStream(changelogFile);
        OutputStreamWriter logWriter = new OutputStreamWriter(logStream);
        logWriter.write(String.format("<%s>\n", "multi-scm-log"));
        for (SCM scm : this.scms) {
            File subChangeLog = changelogFile != null ? new File(changelogFile.getPath() + ".temp") : null;
            SCMRevisionState workspaceRevision = null;
            if (oldBaseline != null) {
                workspaceRevision = oldBaseline.get(scm, workspace, build instanceof AbstractBuild ? (AbstractBuild)build : null);
            }
            scm.checkout(build, launcher, workspace, listener, subChangeLog, workspaceRevision);
            List actions = build.getActions();
            for (Action a : actions) {
                if (scmActions.contains(a) || !(a instanceof SCMRevisionState) || a instanceof MultiSCMRevisionState) continue;
                scmActions.add(a);
                revisionState.add(scm, workspace, build, (SCMRevisionState)a);
            }
            if (subChangeLog == null || !subChangeLog.exists()) continue;
            String subLogText = FileUtils.readFileToString((File)subChangeLog);
            logWriter.write(String.format("<%s scm=\"%s\">\n<![CDATA[%s]]>\n</%s>\n", "sub-log", StringEscapeUtils.escapeXml((String)scm.getKey()), StringEscapeUtils.escapeXml((String)subLogText), "sub-log"));
            subChangeLog.delete();
        }
        logWriter.write(String.format("</%s>\n", "multi-scm-log"));
        logWriter.close();
    }

    public FilePath[] getModuleRoots(FilePath workspace, AbstractBuild build) {
        ArrayList<FilePath> paths = new ArrayList<FilePath>();
        for (SCM scm : this.scms) {
            FilePath[] p;
            for (FilePath p2 : p = scm.getModuleRoots(workspace, build)) {
                paths.add(p2);
            }
        }
        return paths.toArray(new FilePath[paths.size()]);
    }

    public boolean supportsPolling() {
        for (SCM scm : this.scms) {
            if (scm.supportsPolling()) continue;
            return false;
        }
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        for (SCM scm : this.scms) {
            if (!scm.requiresWorkspaceForPolling()) continue;
            return true;
        }
        return false;
    }

    public ChangeLogParser createChangeLogParser() {
        return new MultiSCMChangeLogParser(this.scms.toList());
    }

    public void save() throws IOException {
    }

    @Extension
    public static final class DescriptorImpl
    extends SCMDescriptor<MultiSCM> {
        public DescriptorImpl() {
            super(MultiSCMRepositoryBrowser.class);
        }

        public List<SCMDescriptor<?>> getApplicableSCMs(AbstractProject<?, ?> project) {
            ArrayList scms = new ArrayList();
            for (SCMDescriptor scm : SCM._for(project)) {
                if (scm instanceof DescriptorImpl || scm instanceof NullSCM.DescriptorImpl) continue;
                scms.add(scm);
            }
            return scms;
        }

        public String getDisplayName() {
            return "Multiple SCMs";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            LinkedList<SCM> scmList = new LinkedList<SCM>();
            if (formData.containsKey((Object)"scmList")) {
                JSONObject scm = formData.optJSONObject("scmList");
                if (scm == null) {
                    for (Object obj : formData.getJSONArray("scmList")) {
                        DescriptorImpl.readItem(req, (JSONObject)obj, scmList);
                    }
                } else {
                    DescriptorImpl.readItem(req, scm, scmList);
                }
            }
            try {
                return new MultiSCM(scmList);
            }
            catch (IOException ex) {
                throw new Descriptor.FormException((Throwable)ex, "scmList");
            }
        }

        private static void readItem(StaplerRequest req, JSONObject obj, List<SCM> dest) throws Descriptor.FormException {
            String staplerClass = obj.getString("stapler-class");
            Descriptor d = Hudson.getInstance().getDescriptor(staplerClass);
            dest.add((SCM)d.newInstance(req, obj));
        }
    }
}

