/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mattermost.workflow;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.mattermost.MattermostNotifier;
import jenkins.plugins.mattermost.MattermostService;
import jenkins.plugins.mattermost.StandardMattermostService;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MattermostSendStep
extends Step {
    @Nonnull
    private final String message;
    private String text;
    private String color;
    private String channel;
    private String endpoint;
    private String icon;
    private boolean failOnError;

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    public String getText() {
        return this.text;
    }

    public String getColor() {
        return this.color;
    }

    @DataBoundSetter
    public void setText(String text) {
        this.text = Util.fixEmpty((String)text);
    }

    @DataBoundSetter
    public void setColor(String color) {
        this.color = Util.fixEmpty((String)color);
    }

    public String getChannel() {
        return this.channel;
    }

    @DataBoundSetter
    public void setChannel(String channel) {
        this.channel = Util.fixEmpty((String)channel);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @DataBoundSetter
    public void setEndpoint(String endpoint) {
        this.endpoint = Util.fixEmpty((String)endpoint);
    }

    public String getIcon() {
        return this.icon;
    }

    @DataBoundSetter
    public void setIcon(String icon) {
        this.icon = Util.fixEmpty((String)icon);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @DataBoundConstructor
    public MattermostSendStep(@Nonnull String message) {
        this.message = message;
    }

    public StepExecution start(StepContext context) {
        return new MattermostSendStepExecution(context, this);
    }

    public static class MattermostSendStepExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        transient MattermostSendStep step;
        transient TaskListener listener;

        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
        protected MattermostSendStepExecution(StepContext context, MattermostSendStep mattermostSendStep) {
            super(context);
            this.step = mattermostSendStep;
            try {
                this.listener = (TaskListener)this.getContext().get(TaskListener.class);
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }

        protected Void run() throws Exception {
            String channel;
            Jenkins jenkins;
            try {
                jenkins = Jenkins.get();
            }
            catch (NullPointerException ne) {
                this.listener.error(String.format("Mattermost notification failed with exception: %s", ne), new Object[]{ne});
                return null;
            }
            MattermostNotifier.DescriptorImpl mattermostDesc = (MattermostNotifier.DescriptorImpl)jenkins.getDescriptorByType(MattermostNotifier.DescriptorImpl.class);
            if (mattermostDesc == null) {
                mattermostDesc = (MattermostNotifier.DescriptorImpl)jenkins.getDescriptor("mattermostNotifier");
            }
            String team = this.step.getEndpoint() != null ? this.step.getEndpoint() : mattermostDesc.getEndpoint().getPlainText();
            String string = channel = this.step.channel != null ? this.step.channel : mattermostDesc.getRoom();
            String icon = this.step.icon != null ? this.step.icon : (mattermostDesc.getIcon() != null ? mattermostDesc.getIcon() : "");
            String color = this.step.color != null ? this.step.color : "";
            String text = this.step.text != null ? this.step.text : "";
            this.listener.getLogger().printf("Mattermost Send Pipeline step configured values from global config - connector: %s, icon: %s, channel: %s, color: %s", this.step.endpoint == null, this.step.icon == null, this.step.channel == null, this.step.color == null);
            MattermostService mattermostService = this.getMattermostService(team, channel, icon);
            boolean publishSuccess = mattermostService.publish(this.step.message, text, color);
            if (!publishSuccess && this.step.failOnError) {
                throw new AbortException("Mattermost notification failed. See Jenkins logs for details.");
            }
            if (!publishSuccess) {
                this.listener.error("Mattermost notification failed. See Jenkins logs for details.");
            }
            return null;
        }

        MattermostService getMattermostService(String team, String channel, String icon) {
            return new StandardMattermostService(team, channel, icon);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "mattermostSend";
        }

        public String getDisplayName() {
            return "Send Mattermost message";
        }
    }
}

