/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mattermost;

import hudson.ProxyConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.plugins.mattermost.MattermostNotifier;
import jenkins.plugins.mattermost.MattermostService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.ssl.SSLContexts;
import org.json.JSONArray;
import org.json.JSONObject;

public class StandardMattermostService
implements MattermostService {
    private static final Logger logger = Logger.getLogger(StandardMattermostService.class.getName());
    private String endpoint;
    private final String[] channelIds;
    private final String icon;

    public StandardMattermostService(String endpoint, String channelId, String icon) {
        this.endpoint = endpoint;
        this.channelIds = channelId.split("[,;]+");
        this.icon = icon;
    }

    private static JSONObject createPayload(String message, String text, String color, String roomId, String userId, String icon) {
        JSONObject json = new JSONObject();
        JSONObject field = new JSONObject();
        field.put("short", false);
        field.put("value", (Object)message);
        JSONArray fields = new JSONArray();
        fields.put((Object)field);
        JSONObject attachment = new JSONObject();
        attachment.put("fallback", (Object)message);
        attachment.put("color", (Object)color);
        attachment.put("fields", (Object)fields);
        JSONArray mrkdwn = new JSONArray();
        mrkdwn.put((Object)"pretext");
        mrkdwn.put((Object)"text");
        mrkdwn.put((Object)"fields");
        attachment.put("mrkdwn_in", (Object)mrkdwn);
        JSONArray attachments = new JSONArray();
        attachments.put((Object)attachment);
        json.put("text", (Object)text);
        json.put("attachments", (Object)attachments);
        if (!roomId.isEmpty()) {
            json.put("channel", (Object)roomId);
        }
        json.put("username", (Object)userId);
        json.put("icon_url", (Object)icon);
        return json;
    }

    public static String createRegexFromGlob(String glob) {
        StringBuilder out = new StringBuilder("^");
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*");
                    continue block6;
                }
                case '?': {
                    out.append('.');
                    continue block6;
                }
                case '.': {
                    out.append("\\.");
                    continue block6;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        out.append('$');
        return out.toString();
    }

    private static MattermostNotifier.DescriptorImpl getServiceDescriptor() {
        MattermostNotifier.DescriptorImpl mattermostNotifierDescriptor = (MattermostNotifier.DescriptorImpl)Jenkins.get().getDescriptorByType(MattermostNotifier.DescriptorImpl.class);
        if (mattermostNotifierDescriptor == null) {
            logger.fine("Could not get MattermostNotifier descriptor by class, trying by ID..");
            mattermostNotifierDescriptor = (MattermostNotifier.DescriptorImpl)Jenkins.get().getDescriptor("mattermostNotifier");
        }
        return mattermostNotifierDescriptor;
    }

    @Override
    public boolean publish(String message) {
        return this.publish(message, "warning");
    }

    @Override
    public boolean publish(String message, String color) {
        return this.publish(message, "", color);
    }

    @Override
    public boolean publish(String message, String text, String color) {
        boolean result = true;
        for (String userAndRoomId : this.channelIds) {
            try {
                String roomIdString;
                String roomId = userAndRoomId.trim();
                String userId = "jenkins";
                URL url = new URL(this.endpoint);
                HttpHost httpHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
                HttpClientBuilder clientBuilder = HttpClients.custom();
                clientBuilder.setSSLContext(SSLContexts.createDefault());
                RequestConfig.Builder reqconfigconbuilder = RequestConfig.custom();
                reqconfigconbuilder.setConnectTimeout(10000);
                reqconfigconbuilder.setSocketTimeout(10000);
                ProxyConfiguration globalProxy = Jenkins.get().proxy;
                MattermostNotifier.DescriptorImpl serviceDescriptor = StandardMattermostService.getServiceDescriptor();
                if (serviceDescriptor.isUseCustomProxy()) {
                    ProxyConfiguration customProxy = new ProxyConfiguration(serviceDescriptor.getProxyServer(), serviceDescriptor.getProxyPort(), serviceDescriptor.getProxyUsername(), serviceDescriptor.getProxyPassword().getPlainText(), null, null);
                    this.setupProxy(customProxy, clientBuilder, reqconfigconbuilder);
                    logger.info("MattermostNotifier using custom proxy: " + customProxy.name + ":" + customProxy.port);
                } else if (globalProxy != null && this.isProxyRequired(ProxyConfiguration.getNoProxyHostPatterns((String)globalProxy.noProxyHost))) {
                    this.setupProxy(globalProxy, clientBuilder, reqconfigconbuilder);
                }
                RequestConfig config = reqconfigconbuilder.build();
                CloseableHttpClient client = clientBuilder.build();
                RequestBuilder requestBuilder = RequestBuilder.post((URI)url.toURI());
                requestBuilder.setConfig(config);
                requestBuilder.setCharset(StandardCharsets.UTF_8);
                int atPos = userAndRoomId.indexOf("@");
                if (atPos > 0 && atPos < userAndRoomId.length() - 1) {
                    userId = userAndRoomId.substring(0, atPos).trim();
                    roomId = userAndRoomId.substring(atPos + 1).trim();
                }
                if ((roomIdString = roomId).isEmpty()) {
                    roomIdString = "(default)";
                }
                JSONObject json = StandardMattermostService.createPayload(message, text, color, roomId, userId, this.icon);
                logger.info("Playload: " + json.toString());
                requestBuilder.setEntity((HttpEntity)new StringEntity(json.toString(), ContentType.APPLICATION_JSON));
                CloseableHttpResponse execute = client.execute(httpHost, (HttpRequest)requestBuilder.build());
                int responseCode = execute.getStatusLine().getStatusCode();
                if (responseCode != 200) {
                    result = false;
                    this.logHttpErrorStatus(execute, responseCode, roomIdString, url);
                    continue;
                }
                logger.info("Status " + responseCode + ": to " + roomIdString + "@" + url.getHost() + "/***: " + message + " (" + color + ")");
            }
            catch (IOException | URISyntaxException e) {
                logger.log(Level.WARNING, "Error posting to Mattermost", e);
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logHttpErrorStatus(CloseableHttpResponse execute, int responseCode, String roomIdString, URL hosturl) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(execute.getEntity().getContent(), Charset.defaultCharset()));){
            String collect = bufferedReader.lines().collect(Collectors.joining(" "));
            logger.log(Level.WARNING, "WARN Status " + responseCode + ": to " + roomIdString + "@" + hosturl.getHost() + ": " + collect);
        }
    }

    private RequestConfig.Builder setupProxy(ProxyConfiguration proxy, HttpClientBuilder clientBuilder, RequestConfig.Builder reqconfigconbuilder) throws MalformedURLException {
        HttpHost proxyHost = new HttpHost(proxy.name, proxy.port);
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost);
        clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        reqconfigconbuilder.setProxy(proxyHost);
        this.setupProxyAuth(proxy, clientBuilder, proxyHost);
        return reqconfigconbuilder;
    }

    private void setupProxyAuth(ProxyConfiguration proxy, HttpClientBuilder clientBuilder, HttpHost proxyHost) {
        String username = proxy.getUserName();
        String password = proxy.getPassword();
        if (username != null && !username.isEmpty()) {
            logger.info("Using proxy authentication (user=" + username + ")");
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope(proxyHost.getHostName(), proxy.port), (Credentials)new UsernamePasswordCredentials(username, password));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
    }

    protected boolean isProxyRequired(List<Pattern> noProxyHosts) {
        try {
            URL url = new URL(this.endpoint);
            for (Pattern p : noProxyHosts) {
                if (!p.matcher(url.getHost()).matches()) continue;
                return false;
            }
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "A malformed URL [" + this.endpoint + "] is defined as endpoint, please check your settings");
            return true;
        }
        return true;
    }

    @Deprecated
    protected boolean isProxyRequired(String ... noProxyHost) {
        if (noProxyHost == null) {
            return false;
        }
        List<String> lst = Arrays.asList(noProxyHost);
        List<Pattern> collect = lst.stream().filter(Objects::nonNull).map(StandardMattermostService::createRegexFromGlob).map(Pattern::compile).collect(Collectors.toList());
        return this.isProxyRequired(collect);
    }

    void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }
}

