/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mattermost;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.triggers.SCMTrigger;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.mattermost.CommitInfoChoice;
import jenkins.plugins.mattermost.FineGrainedNotifier;
import jenkins.plugins.mattermost.MattermostListener;
import jenkins.plugins.mattermost.MattermostNotifier;
import jenkins.plugins.mattermost.MattermostService;
import org.apache.commons.lang.StringUtils;

public class ActiveNotifier
implements FineGrainedNotifier {
    private static final Logger logger = Logger.getLogger(MattermostListener.class.getName());
    MattermostNotifier notifier;
    BuildListener listener;

    public ActiveNotifier(MattermostNotifier notifier, BuildListener listener) {
        this.notifier = notifier;
        this.listener = listener;
    }

    private MattermostService getMattermost(AbstractBuild r) {
        return this.notifier.newMattermostService(r, this.listener);
    }

    @Override
    public void deleted(AbstractBuild r) {
    }

    @Override
    public void started(AbstractBuild build) {
        Cause scmCause;
        CauseAction causeAction = (CauseAction)build.getAction(CauseAction.class);
        if (causeAction != null && (scmCause = causeAction.findCause(SCMTrigger.SCMTriggerCause.class)) == null) {
            MessageBuilder message = new MessageBuilder(this.notifier, build);
            message.append(causeAction.getShortDescription());
            this.notifyStart(build, message.appendOpenLink().toString());
            return;
        }
        String changes = this.getChanges(build, this.notifier.getIncludeCustomAttachmentMessage());
        if (changes != null) {
            this.notifyStart(build, changes);
        } else {
            this.notifyStart(build, this.getBuildStatusMessage(build, false, this.notifier.getIncludeCustomAttachmentMessage()));
        }
    }

    private void notifyStart(AbstractBuild build, String attachmentMessage) {
        AbstractProject project = build != null ? build.getProject() : null;
        AbstractBuild previousBuild = project != null && project.getLastBuild() != null ? (AbstractBuild)project.getLastBuild().getPreviousCompletedBuild() : null;
        String expandedCustomMessage = this.getExpandedCustomMessage(build);
        if (previousBuild == null) {
            this.getMattermost(build).publish(attachmentMessage, expandedCustomMessage, "good");
        } else {
            this.getMattermost(build).publish(attachmentMessage, expandedCustomMessage, ActiveNotifier.getBuildColor(previousBuild));
        }
    }

    @Override
    public void finalized(AbstractBuild r) {
    }

    @Override
    public void completed(AbstractBuild r) {
        Result previousResult;
        AbstractProject project = r.getProject();
        Result result = r.getResult();
        AbstractBuild previousBuild = project.getLastBuild();
        if (previousBuild != null) {
            while ((previousBuild = (AbstractBuild)previousBuild.getPreviousCompletedBuild()) != null && previousBuild.getResult() == Result.ABORTED) {
            }
        }
        Result result2 = previousResult = previousBuild != null ? previousBuild.getResult() : Result.SUCCESS;
        if (result == Result.ABORTED && this.notifier.getNotifyAborted() || result == Result.FAILURE && previousResult != Result.FAILURE && this.notifier.getNotifyFailure() || result == Result.FAILURE && previousResult == Result.FAILURE && this.notifier.getNotifyRepeatedFailure() || result == Result.NOT_BUILT && this.notifier.getNotifyNotBuilt() || result == Result.SUCCESS && (previousResult == Result.FAILURE || previousResult == Result.UNSTABLE) && this.notifier.getNotifyBackToNormal() || result == Result.SUCCESS && this.notifier.getNotifySuccess() || result == Result.UNSTABLE && this.notifier.getNotifyUnstable()) {
            String expandedCustomMessage = this.getExpandedCustomMessage(r);
            this.getMattermost(r).publish(this.getBuildStatusMessage(r, this.notifier.getIncludeTestSummary(), this.notifier.getIncludeCustomAttachmentMessage()), expandedCustomMessage, ActiveNotifier.getBuildColor(r));
            if (this.notifier.getCommitInfoChoice().showAnything()) {
                this.getMattermost(r).publish(this.getCommitList(r), expandedCustomMessage, ActiveNotifier.getBuildColor(r));
            }
        }
    }

    String getChanges(AbstractBuild r, boolean includeCustomAttachmentMessage) {
        if (!r.hasChangeSetComputed()) {
            logger.info("No change set computed...");
            return null;
        }
        ChangeLogSet changeSet = r.getChangeSet();
        LinkedList<ChangeLogSet.Entry> entries = new LinkedList<ChangeLogSet.Entry>();
        HashSet files = new HashSet();
        for (Object o : changeSet.getItems()) {
            ChangeLogSet.Entry entry = (ChangeLogSet.Entry)o;
            logger.info("Entry " + o);
            entries.add(entry);
            files.addAll(entry.getAffectedFiles());
        }
        if (entries.isEmpty()) {
            logger.info("Empty change...");
            return null;
        }
        HashSet<String> authors = new HashSet<String>();
        for (ChangeLogSet.Entry entry : entries) {
            authors.add(entry.getAuthor().getDisplayName());
        }
        MessageBuilder message = new MessageBuilder(this.notifier, r);
        message.append(":pray: Started by changes from ");
        message.append(StringUtils.join(authors, (String)", "));
        message.append(" (");
        message.append(files.size());
        message.append(" file(s) changed)");
        message.appendOpenLink();
        if (includeCustomAttachmentMessage) {
            message.appendCustomAttachmentMessage();
        }
        return message.toString();
    }

    String getCommitList(AbstractBuild r) {
        ChangeLogSet changeSet = r.getChangeSet();
        LinkedList<ChangeLogSet.Entry> entries = new LinkedList<ChangeLogSet.Entry>();
        for (Object o : changeSet.getItems()) {
            ChangeLogSet.Entry entry = (ChangeLogSet.Entry)o;
            logger.info("Entry " + o);
            entries.add(entry);
        }
        if (entries.isEmpty()) {
            logger.info("Empty change...");
            Cause.UpstreamCause c = (Cause.UpstreamCause)r.getCause(Cause.UpstreamCause.class);
            if (c == null) {
                return "No Changes.";
            }
            String upProjectName = c.getUpstreamProject();
            int buildNumber = c.getUpstreamBuild();
            AbstractProject project = (AbstractProject)Hudson.getInstance().getItemByFullName(upProjectName, AbstractProject.class);
            if (project == null) {
                return "No upstream project.";
            }
            AbstractBuild upBuild = project.getBuildByNumber(buildNumber);
            return this.getCommitList(upBuild);
        }
        HashSet<String> commits = new HashSet<String>();
        for (ChangeLogSet.Entry entry : entries) {
            StringBuffer commit = new StringBuffer();
            CommitInfoChoice commitInfoChoice = this.notifier.getCommitInfoChoice();
            if (commitInfoChoice.showTitle()) {
                commit.append(entry.getMsg());
            }
            if (commitInfoChoice.showAuthor()) {
                commit.append(" [").append(entry.getAuthor().getDisplayName()).append("]");
            }
            commits.add(commit.toString());
        }
        MessageBuilder message = new MessageBuilder(this.notifier, r);
        message.append("Changes:\n- ");
        message.append(StringUtils.join(commits, (String)"\n- "));
        return message.toString();
    }

    static String getBuildColor(AbstractBuild r) {
        Result result = r.getResult();
        if (result == Result.SUCCESS) {
            return "good";
        }
        if (result == Result.FAILURE) {
            return "danger";
        }
        return "warning";
    }

    String getBuildStatusMessage(AbstractBuild r, boolean includeTestSummary, boolean includeCustomAttachmentMessage) {
        MessageBuilder message = new MessageBuilder(this.notifier, r);
        message.appendStatusMessage();
        message.appendDuration();
        message.appendOpenLink();
        if (includeTestSummary) {
            message.appendTestSummary();
        }
        if (includeCustomAttachmentMessage) {
            message.appendCustomAttachmentMessage();
        }
        return message.toString();
    }

    String getExpandedCustomMessage(AbstractBuild build) {
        String result = "";
        if (this.notifier.getIncludeCustomMessage()) {
            String customMessage = this.notifier.getCustomMessage();
            EnvVars envVars = new EnvVars();
            try {
                envVars = build.getEnvironment((TaskListener)new LogTaskListener(logger, Level.INFO));
            }
            catch (IOException | InterruptedException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            result = envVars.expand(customMessage);
        }
        return result;
    }

    public static class MessageBuilder {
        private static final String STARTING_STATUS_MESSAGE = ":pray: Starting...";
        private static final String BACK_TO_NORMAL_STATUS_MESSAGE = ":white_check_mark: Back to normal";
        private static final String STILL_FAILING_STATUS_MESSAGE = ":no_entry_sign: Still Failing";
        private static final String SUCCESS_STATUS_MESSAGE = ":white_check_mark: Success";
        private static final String FAILURE_STATUS_MESSAGE = ":no_entry_sign: Failure";
        private static final String ABORTED_STATUS_MESSAGE = ":warning: Aborted";
        private static final String NOT_BUILT_STATUS_MESSAGE = ":warning: Not built";
        private static final String UNSTABLE_STATUS_MESSAGE = ":warning: Unstable";
        private static final String UNKNOWN_STATUS_MESSAGE = ":question: Unknown";
        private StringBuffer message;
        private MattermostNotifier notifier;
        private AbstractBuild build;

        public MessageBuilder(MattermostNotifier notifier, AbstractBuild build) {
            this.notifier = notifier;
            this.message = new StringBuffer();
            this.build = build;
            this.startMessage();
        }

        public MessageBuilder appendStatusMessage() {
            this.message.append(this.escape(MessageBuilder.getStatusMessage(this.build)));
            return this;
        }

        static String getStatusMessage(AbstractBuild r) {
            Run lastNonAbortedBuild;
            if (r.isBuilding()) {
                return STARTING_STATUS_MESSAGE;
            }
            Result result = r.getResult();
            AbstractBuild lastBuild = r.getProject().getLastBuild();
            Run previousBuild = lastBuild != null ? lastBuild.getPreviousBuild() : null;
            Run previousSuccessfulBuild = r.getPreviousSuccessfulBuild();
            boolean buildHasSucceededBefore = previousSuccessfulBuild != null;
            for (lastNonAbortedBuild = previousBuild; lastNonAbortedBuild != null && lastNonAbortedBuild.getResult() == Result.ABORTED; lastNonAbortedBuild = lastNonAbortedBuild.getPreviousBuild()) {
            }
            Result previousResult = lastNonAbortedBuild == null ? Result.SUCCESS : lastNonAbortedBuild.getResult();
            if (result == Result.SUCCESS && (previousResult == Result.FAILURE || previousResult == Result.UNSTABLE) && buildHasSucceededBefore) {
                return BACK_TO_NORMAL_STATUS_MESSAGE;
            }
            if (result == Result.FAILURE && previousResult == Result.FAILURE) {
                return STILL_FAILING_STATUS_MESSAGE;
            }
            if (result == Result.SUCCESS) {
                return SUCCESS_STATUS_MESSAGE;
            }
            if (result == Result.FAILURE) {
                return FAILURE_STATUS_MESSAGE;
            }
            if (result == Result.ABORTED) {
                return ABORTED_STATUS_MESSAGE;
            }
            if (result == Result.NOT_BUILT) {
                return NOT_BUILT_STATUS_MESSAGE;
            }
            if (result == Result.UNSTABLE) {
                return UNSTABLE_STATUS_MESSAGE;
            }
            return UNKNOWN_STATUS_MESSAGE;
        }

        public MessageBuilder append(String string) {
            this.message.append(this.escape(string));
            return this;
        }

        public MessageBuilder append(Object string) {
            this.message.append(this.escape(string.toString()));
            return this;
        }

        private MessageBuilder startMessage() {
            this.message.append(this.escape(this.build.getProject().getFullDisplayName()));
            this.message.append(" - ");
            this.message.append(this.escape(this.build.getDisplayName()));
            this.message.append(" ");
            return this;
        }

        public MessageBuilder appendOpenLink() {
            String url = this.notifier.getBuildServerUrl() + this.build.getUrl();
            this.message.append(" [Open](").append(url).append(")");
            return this;
        }

        public MessageBuilder appendDuration() {
            this.message.append(" after ");
            String durationString = this.message.toString().contains(BACK_TO_NORMAL_STATUS_MESSAGE) ? this.createBackToNormalDurationString() : this.build.getDurationString();
            this.message.append(durationString);
            return this;
        }

        public MessageBuilder appendTestSummary() {
            AbstractTestResultAction action = (AbstractTestResultAction)this.build.getAction(AbstractTestResultAction.class);
            if (action != null) {
                int total = action.getTotalCount();
                int failed = action.getFailCount();
                int skipped = action.getSkipCount();
                this.message.append("\nTest Status:\n");
                this.message.append("\tPassed: " + (total - failed - skipped));
                this.message.append(", Failed: " + failed);
                this.message.append(", Skipped: " + skipped);
            } else {
                this.message.append("\nNo Tests found.");
            }
            return this;
        }

        public MessageBuilder appendCustomAttachmentMessage() {
            String customAttachmentMessage = this.notifier.getCustomAttachmentMessage();
            EnvVars envVars = new EnvVars();
            try {
                envVars = this.build.getEnvironment((TaskListener)new LogTaskListener(logger, Level.INFO));
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.message.append("\n");
            this.message.append(envVars.expand(customAttachmentMessage));
            return this;
        }

        private String createBackToNormalDurationString() {
            Run previousSuccessfulBuild = this.build.getPreviousSuccessfulBuild();
            if (previousSuccessfulBuild == null) {
                return "unknown";
            }
            long previousSuccessStartTime = previousSuccessfulBuild.getStartTimeInMillis();
            long previousSuccessDuration = previousSuccessfulBuild.getDuration();
            long previousSuccessEndTime = previousSuccessStartTime + previousSuccessDuration;
            long buildStartTime = this.build.getStartTimeInMillis();
            long buildDuration = this.build.getDuration();
            long buildEndTime = buildStartTime + buildDuration;
            long backToNormalDuration = buildEndTime - previousSuccessEndTime;
            return Util.getTimeSpanString((long)backToNormalDuration);
        }

        public String escape(String string) {
            string = string.replace("&", "&amp;");
            string = string.replace("<", "&lt;");
            string = string.replace(">", "&gt;");
            return string;
        }

        public String toString() {
            return this.message.toString();
        }
    }
}

