/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import hudson.Util;
import hudson.model.User;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException2;
import hudson.util.FormValidation;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.symbol.Symbol;
import org.jenkins.ui.symbol.SymbolRequest;
import org.jenkinsci.plugins.matrixauth.AuthorizationType;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@Restricted(value={NoExternalUse.class})
class ValidationUtil {
    private static final String userSymbol = ValidationUtil.getSymbol("person", "icon-sm");
    private static final String groupSymbol = ValidationUtil.getSymbol("people", "icon-sm");
    private static final String warningSymbol;
    private static final String alertSymbol;

    private ValidationUtil() {
    }

    private static String getSymbol(String symbol, String classes) {
        SymbolRequest.Builder builder = new SymbolRequest.Builder();
        return Symbol.get((SymbolRequest)builder.withRaw("symbol-" + symbol + "-outline plugin-ionicons-api").withClasses(classes).build());
    }

    static String formatNonExistentUserGroupValidationResponse(String user, String tooltip) {
        return ValidationUtil.formatNonExistentUserGroupValidationResponse(user, tooltip, false);
    }

    static String formatNonExistentUserGroupValidationResponse(String user, String tooltip, boolean warning) {
        return ValidationUtil.formatUserGroupValidationResponse("alert", "<span class='mas-table__cell--not-found'>" + user + "</span>", tooltip, warning);
    }

    static String formatUserGroupValidationResponse(@NonNull AuthorizationType type, String user, String tooltip) {
        return ValidationUtil.formatUserGroupValidationResponse(type.toString(), user, tooltip, false);
    }

    static String formatUserGroupValidationResponse(@NonNull AuthorizationType type, String user, String tooltip, boolean warning) {
        return ValidationUtil.formatUserGroupValidationResponse(type.toString(), user, tooltip, warning);
    }

    static String formatUserGroupValidationResponse(@NonNull String type, String user, String tooltip, boolean warning) {
        String symbol = switch (type) {
            case "GROUP" -> groupSymbol;
            case "alert" -> alertSymbol;
            case "USER" -> userSymbol;
            default -> "";
        };
        if (warning) {
            return String.format("<div tooltip='%s' class='mas-table__cell mas-table__cell-warning'>%s%s%s</div>", tooltip, warningSymbol, symbol, user);
        }
        return String.format("<div tooltip='%s' class='mas-table__cell'>%s%s</div>", tooltip, symbol, user);
    }

    static FormValidation validateGroup(String groupName, SecurityRealm sr, boolean ambiguous) {
        String escapedSid = Functions.escape((String)groupName);
        try {
            sr.loadGroupByGroupname2(groupName, false);
            if (ambiguous) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.WARNING, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.GROUP, escapedSid, "Group found; but permissions would also be granted to a user of this name", true));
            }
            return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.GROUP, escapedSid, "Group"));
        }
        catch (UserMayOrMayNotExistException2 e) {
            if (ambiguous) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.WARNING, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.GROUP, escapedSid, "Permissions would also be granted to a user or group of this name", true));
            }
            return FormValidation.ok((String)escapedSid);
        }
        catch (UsernameNotFoundException e) {
        }
        catch (AuthenticationException e) {
            return FormValidation.error((Throwable)e, (String)("Failed to test the validity of the group name " + groupName));
        }
        return null;
    }

    static FormValidation validateUser(String userName, SecurityRealm sr, boolean ambiguous) {
        String escapedSid = Functions.escape((String)userName);
        try {
            sr.loadUserByUsername2(userName);
            User u = User.getById((String)userName, (boolean)true);
            if (userName.equals(u.getFullName())) {
                if (ambiguous) {
                    return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.WARNING, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.USER, escapedSid, "User found; but permissions would also be granted to a group of this name", true));
                }
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.USER, escapedSid, "User"));
            }
            if (ambiguous) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.WARNING, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.USER, Util.escape((String)StringUtils.abbreviate((String)u.getFullName(), (int)50)), "User " + escapedSid + " found; but permissions would also be granted to a group of this name", true));
            }
            return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.USER, Util.escape((String)StringUtils.abbreviate((String)u.getFullName(), (int)50)), "User " + escapedSid));
        }
        catch (UserMayOrMayNotExistException2 e) {
            if (ambiguous) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.WARNING, (String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.EITHER, escapedSid, "Permissions would also be granted to a user or group of this name", true));
            }
            return FormValidation.ok((String)userName);
        }
        catch (UsernameNotFoundException e) {
        }
        catch (AuthenticationException e) {
            return FormValidation.error((Throwable)e, (String)("Failed to test the validity of the user ID " + userName));
        }
        return null;
    }

    static {
        alertSymbol = ValidationUtil.getSymbol("alert-circle", "icon-md mas-table__icon-alert");
        warningSymbol = ValidationUtil.getSymbol("warning", "icon-md mas-table__icon-warning");
    }
}

